package de.renew.draw.ui.impl.services;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.api.services.UndoRedoService;
import de.renew.draw.ui.ontology.undoredo.UndoRedoManager;

/**
 * Service class that implements the methods for the {@link de.renew.draw.ui.api.UndoRedoApi} to call.
 *
 * @author Clara von Bargen
 */
public class UndoRedoServiceImpl implements UndoRedoService {
    @Override
    public void prepareUndoSnapshot() {
        Drawing drawing = EditorApi.getCurrentDrawing();
        prepareUndoSnapshot(drawing);
    }

    @Override
    public void prepareUndoSnapshot(Drawing drawing) {
        UndoRedoManager undoRedoManager = EditorApi.getCurrentEditor().getUndoRedoManager();
        if (undoRedoManager != null) {
            undoRedoManager.prepareUndoSnapshot(drawing);
        }
    }

    @Override
    public void commitUndoSnapshot() {
        Drawing drawing = EditorApi.getCurrentDrawing();
        commitUndoSnapshot(drawing);
    }

    @Override
    public void commitUndoSnapshot(Drawing drawing) {
        UndoRedoManager undoRedoManager = EditorApi.getCurrentEditor().getUndoRedoManager();
        if (undoRedoManager != null) {
            undoRedoManager.commitUndoSnapshot(drawing);
        }
    }

    @Override
    public void clearUndoRedoHistory() {
        Drawing drawing = EditorApi.getCurrentDrawing();
        clearUndoRedoHistory(drawing);
    }

    @Override
    public void clearUndoRedoHistory(Drawing drawing) {
        UndoRedoManager undoRedoManager = EditorApi.getCurrentEditor().getUndoRedoManager();
        if (undoRedoManager != null) {
            undoRedoManager.clearUndoHistory(drawing);
        }
    }

    @Override
    public void restoreUndoSnapshot() {
        Drawing drawing = EditorApi.getCurrentDrawing();
        restoreUndoSnapshot(drawing);
    }

    @Override
    public void restoreUndoSnapshot(Drawing drawing) {
        UndoRedoManager undoRedoManager = EditorApi.getCurrentEditor().getUndoRedoManager();
        if (undoRedoManager != null) {
            undoRedoManager.restoreUndoSnapshot(drawing);
        }
    }
}
