package de.renew.draw.ui.impl.services;

import java.io.File;

import CH.ifa.draw.DrawPlugin;
import de.renew.draw.ui.api.services.DialogService;
import de.renew.draw.ui.impl.dialogs.DialogCreator;
import de.renew.draw.ui.ontology.dialogs.InputDialogBuilder;
import de.renew.draw.ui.ontology.dialogs.MessageDialogBuilder;
import de.renew.draw.ui.ontology.dialogs.OptionDialogBuilder;
import de.renew.ioontology.FileFilter;

public class DialogServiceImpl implements DialogService {
    @Override
    public File showSaveFileDialog(File file, FileFilter filter) {
        return DrawPlugin.getCurrentDrawPlugin().getIOHelper().getSavePath(file, filter);
    }

    @Override
    public File[] showSelectFilesDialog(FileFilter filter) {
        return DrawPlugin.getCurrentDrawPlugin().getIOHelper()
            .getLoadPath((javax.swing.filechooser.FileFilter) filter);
    }

    @Override
    public File showSelectFilesDialog(File file, FileFilter filter) {
        return DrawPlugin.getCurrentDrawPlugin().getIOHelper()
            .getLoadPath(file, (javax.swing.filechooser.FileFilter) filter);
    }

    @Override
    public File[] showSelectFilesDialog(File file, FileFilter filter, boolean multiSelection) {
        return DrawPlugin.getCurrentDrawPlugin().getIOHelper()
            .getLoadPath(file, (javax.swing.filechooser.FileFilter) filter, multiSelection);
    }

    @Override
    public MessageDialogBuilder createMessageDialogBuilder() {
        return DialogCreator.createMessageDialogBuilder();
    }

    @Override
    public InputDialogBuilder createInputDialogBuilder() {
        return DialogCreator.createInputDialogBuilder();
    }

    @Override
    public OptionDialogBuilder createOptionDialogBuilder() {
        return DialogCreator.createOptionDialogBuilder();
    }

}
