package de.renew.draw.ui.impl.dialogs;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import de.renew.draw.ui.ontology.dialogs.DialogMessageType;
import de.renew.draw.ui.ontology.dialogs.MessageDialog;
import de.renew.draw.ui.ontology.dialogs.MessageDialogBuilder;

/**
 * This is the implementation of the message dialog.
 */
final class MessageDialogImpl extends DialogImpl<MessageDialogBuilder> implements MessageDialog {

    private MessageDialogImpl(
        Component parentComponent, String title, DialogMessageType messageType, Icon icon,
        Object message)
    {
        super(parentComponent, title, messageType, icon, message);
    }

    @Override
    public void show() {
        JOptionPane.showMessageDialog(
            this._parentComponent, this._message, this._title,
            DialogAbstractionUtil.convertToSwingMessageType(this._messageType), this._icon);
    }

    @Override
    public void showAsync(Runnable onClosed) {

        SwingUtilities.invokeLater(() -> {
            show();
            onClosed.run();
        });

    }

    @Override
    public MessageDialogBuilder toNewBuilder() {
        return new MessageDialogBuilderImpl().setParentComponent(this._parentComponent)
            .setTitle(this._title).setMessageType(this._messageType).setIcon(this._icon)
            .setMessage(this._message);
    }

    /**
     * The builder of the message dialog.
     */
    static final class MessageDialogBuilderImpl extends DialogBuilderImpl<MessageDialogBuilder>
        implements MessageDialogBuilder
    {

        /**
         * Creates a new instance of the MessageDialogBuilder, used to create {@link MessageDialog}s.
         */
        MessageDialogBuilderImpl() {}

        @Override
        protected MessageDialogBuilderImpl self() {
            return this;
        }

        @Override
        public MessageDialogImpl build() {
            return new MessageDialogImpl(
                this._parentComponent, this._title, this._messageType, this._icon, this._message);
        }

    }

}
