package de.renew.draw.ui.impl.dialogs;

import java.awt.Component;
import javax.swing.Icon;

import CH.ifa.draw.DrawPlugin;
import de.renew.draw.ui.ontology.dialogs.DialogBuilder;
import de.renew.draw.ui.ontology.dialogs.DialogMessageType;

/**
 * The base implementation for all dialog builders. This bundles all common methods for all dialog types.
 * @param <T> The type of the dialog builder that is creating the dialog.
 */
sealed abstract class DialogBuilderImpl<T extends DialogBuilder<?>> implements DialogBuilder<T>
    permits InputDialogImpl.InputDialogBuilderImpl, MessageDialogImpl.MessageDialogBuilderImpl,
    OptionDialogImpl.OptionDialogBuilderImpl
{

    protected Component _parentComponent = null;
    protected String _title = "";
    protected DialogMessageType _messageType = DialogMessageType.PLAIN_MESSAGE;
    protected Icon _icon = null;
    protected Object _message = null;

    DialogBuilderImpl() {}

    /**
     * Returns the current instance of the implementing subclass.
     * @return Instance of builder.
     */
    protected abstract T self();

    @Override
    public T useGuiFrame() {
        this._parentComponent = DrawPlugin.getGui().getFrame();
        return self();
    }

    @Override
    public T setParentComponent(Component parentComponent) {
        this._parentComponent = parentComponent;
        return self();
    }

    @Override
    public T setTitle(String title) {
        this._title = title;
        return self();
    }

    @Override
    public T setMessageType(DialogMessageType messageType) {
        this._messageType = messageType;
        return self();
    }

    @Override
    public T setIcon(Icon icon) {
        this._icon = icon;
        return self();
    }

    @Override
    public T setMessage(Object message) {
        this._message = message;
        return self();
    }

}