package de.renew.draw.ui.api.services;

import java.util.Collection;
import java.util.Vector;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.SelectionApi;
import de.renew.draw.ui.ontology.ErrorState;

/**
 * Service class that provides methods for the {@link SelectionApi} to call.
 */
public interface SelectionService {
    /**
     * Gets the currently selected figures.
     * @return a vector with the selected figures. The vector
     * is a copy of the current selection.
     */
    Vector<Figure> getSelectedFigures();

    /**
     * Gets the currently selected figures in Z order, which means the figures are given bottom to top of the
     * current view. The Z stands for the z-axis of the current view.
     * @return a vector with the selected figures
     */
    Vector<Figure> getSelectedFiguresZOrdered();

    /**
     * Adds a figure to the current selection.
     * @param figure figure to be added into selection
     */
    void addToSelection(Figure figure);

    /**
     * Adds an enumeration of figures to the current selection.
     * @param figureEnumeration figures to be added
     */
    void addToSelectionAll(FigureEnumeration figureEnumeration);

    /**
     * Adds a vector of figures to the current selection.
     * @param figures figures included in vector to be added
     */
    void addToSelectionAll(Collection<Figure> figures);

    /**
     * Invalidates the handles of the current selection.
     * This means that the cached set of handles will be
     * re-calculated next time the selection's handles are
     * queried.
     */
    void selectionInvalidateHandles();

    /**
     * Selects the corresponding elements for the given FigureException.
     *
     * @param errorState the FigureException whose offending elements are searched.
     * @return the offending elements for the exception.
     */
    boolean selectOffendingElements(ErrorState errorState);

    /**
     * Gets the number of selected figures.
     * @return number of selected figures
     */
    int getSelectionCount();

    /**
     * Clears the current selection.
     */
    void clearSelection();
}
