package de.renew.draw.ui.api.services;

import java.awt.Image;

import de.renew.draw.ui.api.ImageApi;

/**
 * Service class that provides methods for the {@link ImageApi} to call.
 * @author Percy Hohberg
 */
public interface ImageService {

    /**
     * Gets the image with the given name.
     * If the image can't be found it tries again after loading all the registered images.
     *
     * @param fileName the fileName, which will be used as a key to access the image
     * @return the requested Image object
     */
    Image getImage(String fileName);


    /**
     * Registers an image that is then loaded together with
     * the other registered images by loadRegisteredImages.
     *
     * @param fileName the name of the image file to register
     */
    void registerImage(String fileName);



    /**
     * Loads an image with the given name.
     *
     * @param fileName the filename where the image will be loaded from
     * @return the now loaded image
     */
    Image loadImage(String fileName);

    /**
     * Registers and loads an image.
     *
     * @param component the component the image will be displayed in
     * @param fileName the filename where the image will be loaded from
     * @return the now loaded and registered image
     */
    Image registerAndLoadImage(String fileName);

    /**
     * Retrieves an Image from the editor, which can be used as the standard icon image.
     * @return the image from the editor.
     */
    Image getIconImage();

}
