package de.renew.draw.ui.api.services;

import java.util.Vector;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.api.ErrorApi;
import de.renew.draw.ui.ontology.ErrorState;

/**
 * Service class that provides methods for the {@link ErrorApi} to call.
 */
public interface ErrorService {

    /**
     * Creates a new ErrorState with the given parameters.
     * <p>
     * This method is to be used if there is only one offending figure whose type is not important.
     *
     * @param title the title for the erroneous state
     * @param message the message describing the erroneous state
     * @param drawing the drawing that contains the erroneous state
     * @param offendingFigure an erroneous figure
     */
    ErrorState createErrorState(
        String title, String message, Drawing drawing, Figure offendingFigure);

    /**
     * Creates a new ErrorState with the given parameters.
     *
     * @param title the title for the erroneous state
     * @param message the message describing the erroneous state
     * @param drawing the drawing that contains the erroneous state
     * @param offendingFigures the erroneous figures
     */
    ErrorState createErrorState(
        String title, String message, Drawing drawing, Vector<? extends Figure> offendingFigures);

    /**
     * Creates a new ErrorState with the given parameters.
     * <p>
     * By giving a specific error figure, it can later be accessed, e.g.
     * to edit its text if it is a text figure.
     *
     * @param message the message describing the erroneous state
     * @param line line index that can be used to determine in which line the text is erroneous if a text figure is given as the specific erroneous figure
     * @param column column index that can be used to determine at which column the text is erroneous if a text figure is given as the specific erroneous figure
     * @param drawing the drawing that contains the erroneous state
     * @param specificErrorFigure a specific figure that is erroneous, e.g. a text figure.
     * @param errorFigures additional erroneous figures
     * @param problemSpecificInformation an object giving specific information for the error
     */
    ErrorState createErrorState(
        String message, int line, int column, Drawing drawing, Figure specificErrorFigure,
        Vector<Figure> errorFigures, Object problemSpecificInformation);

    /**
     * Creates a new ErrorState with the given parameters.
     * <p>
     * By giving a specific error figure, it can later be accessed to e.g. edit its text if its a text figure.
     *
     * @param message the message describing the erroneous state
     * @param line line index that can be used to determine in which line the text is erroneous if a text figure is given as the specific erroneous figure
     * @param column column index that can be used to determine at which column the text is erroneous if a text figure is given as the specific erroneous figure
     * @param drawing the drawing that contains the erroneous state
     * @param specificErrorFigure a specific figure that is erroneous, e.g. a text figure.
     * @param problemSpecificInformation an object giving specific information for the error
     */
    ErrorState createErrorState(
        String message, int line, int column, Drawing drawing, Figure specificErrorFigure,
        Object problemSpecificInformation);
}
