package de.renew.draw.ui.api.services;

import java.io.File;
import java.util.Properties;

import de.renew.draw.ui.api.ApplicationApi;

/**
 * Service class that provides methods for the {@link ApplicationApi} to call.
 */

public interface ApplicationService {

    /**
    * Sets behavior of the drawing via their properties.
    * @param properties the properties to set the gui to.
    */
    void setDrawProperties(Properties properties);

    /**
    * Finds out if a frame can be reshaped.
    * @return <code>true</code> if frames may be positioned and resized by user.
    **/
    boolean isAvoidFrameReshape();

    /**
    * Finds out if graphics are used.
    * @return <code>true</code> if a drawing will be loaded without graphics.
    **/
    boolean isNoGraphics();

    /**
    * Getter for last save path.
    * @return last save path.
    */
    File getLastPath();

    /**
    * Verifies that closing the editor is possible.
    * @return <code>true</code> if it is possible to close the editor.
    */
    boolean canClose();

    /**
    * Requests closing of the editor.
    */
    void requestClose();

    /**
    * Displays a status message in the gui status line.
    * @param message status that is displayed.
    */
    void showStatus(String message);


    /**
    * Register a factory ID. When a new drawing is created, the factory with the given ID is used.
    * @param key Use the name of the drawing as a key.
    * @param id The id of the factory registered at the Workbench.
    */
    void registerDrawingViewFactory(Class<?> key, String id);
}
