package de.renew.draw.storables.ontology.exporting;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.ioontology.MultiExtensionFileFilter;
import de.renew.ioontology.exporting.ExportFormatMultiAbstract;


/**
 * Abstract implementation representing an ExportFormatMulti for Drawings.
 */
public abstract class AbstractDrawingExportFormatMulti extends ExportFormatMultiAbstract<Drawing> {

    /**
     * Constructs drawing multi export format with a given name and a name for the new {@link MultiExtensionFileFilter}.
     * @param name the given name
     * @param filterName the name for the new combination file filter
     */
    public AbstractDrawingExportFormatMulti(String name, String filterName) {
        super(name, filterName);
    }

    @Override
    public boolean canExportObject(Object object) {
        if (object instanceof Drawing drawing) {
            return canExportDrawing(drawing);
        }
        return false;
    }

    /**
     * Tells whether this {@code ExportFormat} can export the given
     * {@code drawing}.
     * @param drawing  the drawing of question.
     * @return  {@code true}, if this export format can handle the
     *          given {@code drawing}.
     *          Returns {@code false}, otherwise.
     */
    public abstract boolean canExportDrawing(Drawing drawing);
}
