package de.renew.draw.storables.ontology;

/**
 * An output stream that can be used to flatten Storable objects.
 * StorableOutput preserves the object identity of the stored objects.
 */
public interface StorableOutput extends StorableInOut {
    /**
     * Writes a storable object to the output stream.
     *
     * @param storable the storable that will be written to the output stream
     */
    void writeStorable(Storable storable);

    /**
     * Writes an int to the output stream.
     *
     * @param number {@code int} that will be written to the output stream
     */
    void writeInt(int number);

    /**
     * Writes a double and a trailing space to the output stream.
     *
     * @param number the double that will be written to the output stream
     */
    void writeDouble(double number);

    /**
     * Writes a boolean with a trailing space (1 for {@code true} 0 for {@code false}) to the output stream.
     *
     * @param bool the boolean that will be written to the output stream
     */
    void writeBoolean(boolean bool);

    /**
     * Writes a string to the output stream. Special characters are quoted.
     *
     * @param string the string that will be written to the output stream
     */
    void writeString(String string);

    /**
     * Closes the storable output stream.
     */
    void close();
}
