package de.renew.draw.storables.ontology;

/**
 * Interface defining filters for figure objects, e.g. if a figure is used.
 */
@FunctionalInterface
public interface FigureFilter {

    /**
     * Decides whether the given figure is accepted by this figure filter.
     * @param figure the figure to be checked
     * @return {@code true}, if the figure is accepted by the filter, {@code false} if not.
     */
    boolean isAcceptedFigure(Figure figure);
}
