/*
 * @(#)FigureChangeEvent.java 5.1
 *
 */

package de.renew.draw.storables.ontology;

import java.awt.Rectangle;

/**
 * FigureChange event passed to FigureChangeListeners.
 *
 */
public interface FigureChangeEvent {

    /**
     *  Gets the changed figure
     * @return the changed figure.
     */
    Figure getFigure();

    /**
     * The object on which the Event initially occurred.
     *
     * @return the object on which the Event initially occurred
     */
    Object getSource();

    /**
     *  Gets the changed rectangle
     * @return the invalidated rectangle
     */
    Rectangle getInvalidatedRectangle();
}