/*
 * @(#)StorableOutput.java 5.1
 *
 */

package CH.ifa.draw.util;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;

import de.renew.draw.storables.ontology.Storable;


/**
 * An output stream that can be used to flatten Storable objects.
 * StorableOutput preserves the object identity of the stored objects.
 * <br>
 * {@link Storable}
 * {@link StorableInput}
 * @deprecated This class should no longer be used and is marked as internal. Please use the {@link de.renew.draw.storables.api.StorableApi instead.}
 */
@Deprecated
public class StorableOutput extends StorableInOut
    implements de.renew.draw.storables.ontology.StorableOutput
{

    /**
     * Logger for the class StorableOutput.
     * Only a single logger instance exists at any given time. If a logger for StorableOutput
     * already exists it is returned or else a new instance is created.
     */
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(StorableOutput.class);
    private PrintWriter _stream;
    private int _indent;

    /**
     * Initializes the StorableOutput with the file given by name.
     *
     * @param file the file from which the FileOutputStream for the PrintWriter will be created
     * @throws FileNotFoundException if file wasn't found
     * @deprecated This constructor is not to be used externally. Please use {@link de.renew.draw.storables.api.StorableApi#createStorableOutput(File)} instead.
     */
    @Deprecated
    public StorableOutput(File file) throws FileNotFoundException {
        this(file.toURI(), new FileOutputStream(file));
    }

    /**
     * Initializes the StorableOutput with the given output stream.
     *
     * @param stream the OutputStream the PrintWriter will be initialized with
     * @deprecated This constructor is not to be used externally. Please use {@link de.renew.draw.storables.api.StorableApi#createStorableOutput(OutputStream)} instead.
     */
    @Deprecated
    public StorableOutput(OutputStream stream) {
        this(null, stream);
    }

    /**
     * Initializes the StorableOutput with the given output stream.
     */
    private StorableOutput(URI location, OutputStream stream) {
        super(location);
        try {
            _stream = new PrintWriter(new OutputStreamWriter(stream, "UTF8"));
        } catch (UnsupportedEncodingException e) {
            LOGGER.error("UTF-8 not supported!");
            _stream = new PrintWriter(stream);
        }
        _indent = 0;
    }

    public StorableOutput() {}

    /**
     * Writes a storable object to the output stream.
     *
     * @param storable the storable that will be written to the output stream
     */
    public void writeStorable(Storable storable) {
        if (storable == null) {
            _stream.print("NULL");
            space();
            return;
        }

        if (mapped(storable)) {
            writeRef(storable);
            return;
        }

        incrementIndent();
        startNewLine();
        map(storable);
        _stream.print(storable.getClass().getName());
        space();
        storable.write(this);
        space();
        decrementIndent();
    }

    /**
     * Writes an int to the output stream.
     *
     * @param i <code>int</code> that will be written to the output stream
     */
    public void writeInt(int i) {
        _stream.print(i);
        space();
    }

    /**
     * Writes a color to the output stream.
     *
     * @param c the color that will be written to the output stream
     */
    public void writeColor(Color c) {
        writeInt(c.getRed());
        writeInt(c.getGreen());
        writeInt(c.getBlue());
    }

    /**
     * Writes a double and a trailing space to the output stream.
     *
     * @param d the double that will be written to the output stream
     */
    public void writeDouble(double d) {
        _stream.print(d);
        space();
    }

    /**
     * Writes a boolean with a trailing space (1 for <code>true</code>, 0 for <code>false</code>) to
     * the output stream.
     *
     * @param b the boolean that will be written to the output stream
     */
    public void writeBoolean(boolean b) {
        if (b) {
            _stream.print(1);
        } else {
            _stream.print(0);
        }
        space();
    }

    /**
     * Writes a string to the output stream. Special characters
     * are quoted.
     *
     * @param s the string that will be written to the output stream
     */
    public void writeString(String s) {
        _stream.print('"');
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            switch (c) {
                case '\n':
                    _stream.print('\\');
                    _stream.print('n');
                    break;
                case '"':
                    _stream.print('\\');
                    _stream.print('"');
                    break;
                case '\\':
                    _stream.print('\\');
                    _stream.print('\\');
                    break;
                case '\t':
                    _stream.print('\\');
                    _stream.print('\t');
                    break;
                default:
                    _stream.print(c);
            }
        }
        _stream.print('"');
        space();
    }

    /**
     * Closes a storable output stream.
     */
    public void close() {
        _stream.close();
    }

    private void writeRef(Storable storable) {
        int ref = getRef(storable);

        _stream.print("REF");
        space();
        _stream.print(ref);
        space();
    }

    private void incrementIndent() {
        _indent += 4;
    }

    private void decrementIndent() {
        _indent -= 4;
        if (_indent < 0) {
            _indent = 0;
        }
    }

    private void startNewLine() {
        _stream.println();
        for (int i = 0; i < _indent; i++) {
            space();
        }
    }

    private void space() {
        _stream.print(' ');
    }
}