/*
 * @(#)ReverseVectorEnumerator.java 5.1
 *
 */

package CH.ifa.draw.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

import de.renew.draw.storables.ontology.Figure;


/**
 * An Enumeration that enumerates a vector back (size-1) to front (0).
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class ReverseVectorEnumerator implements Enumeration<Figure> {
    Vector<Figure> vector;
    int count;

    /**
     * Constructs a ReverseVectorEnumerator, which saves the vector as given but
     * upon calling <code>nextElement()</code> the elements will be returned back to front
     *
     * @param v the vector to be reversed
     */
    public ReverseVectorEnumerator(Vector<Figure> v) {
        vector = v;
        count = vector.size() - 1;
    }

    @Override
    public boolean hasMoreElements() {
        return count >= 0;
    }

    @Override
    public Figure nextElement() {
        if (count >= 0) {
            return vector.elementAt(count--);
        }
        throw new NoSuchElementException("ReverseVectorEnumerator");
    }
}