package CH.ifa.draw.util;

/**
 * This class contains a fontBuffer that contains different fonts
 * and provides functionality to get a specific font.
 */
public class Fontkit {
    private final static int BUFFERSIZE = 100; // number of cached Fonts
    private static final FontDescriptor[] FONTBUFFER = new FontDescriptor[BUFFERSIZE];
    private static int _next = 0;

    /**
     * This function gets a specific font that is contained in the font buffer.
     *
     * @param name the name of the font you want
     * @param style the style of the font you want
     * @param size the size of the font you want
     * @return the font you want
     */
    public static ExtendedFont getFont(String name, int style, int size) {
        FontDescriptor fd;
        for (int i = 0; i < BUFFERSIZE; ++i) {
            fd = FONTBUFFER[i];
            if (fd == null) {
                break;
            }
            if (fd.equals(name, style, size)) {
                return fd.font;
            }
        }
        fd = new FontDescriptor(name, style, size);
        FONTBUFFER[_next] = fd;
        _next = (_next + 1) % BUFFERSIZE;
        return fd.font;
    }
}


class FontDescriptor {
    final String name;
    final int style;
    final int size;
    final ExtendedFont font;

    FontDescriptor(String name, int style, int size) {
        this.name = name;
        this.style = style;
        this.size = size;
        this.font = new ExtendedFont(name, style, size);
    }

    boolean equals(String name, int style, int size) {
        return this.style == style && this.size == size && this.name.equals(name);
    }
}