package CH.ifa.draw.util;

import java.awt.Point;
import java.util.Vector;


/**
 * The coordinates have double precision
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class DoublePoint {
    /**
     * x-coordinate of the DoublePoint
     */
    public double x;
    /**
     * y-coordinate of the DoublePoint
     */
    public double y;

    /**
     * Creates a DoublePoint/tuple (x,y) where x and y are of type double.
     *
     * @param x the x-coordinate
     * @param y the y-coordinate
     */
    public DoublePoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    /**
     * Creates a DoublePoint/tuple (x,y) from a Point object where x and y will be of type double.
     *
     * @param p the Point, whose values will be copied to create a DoublePoint
     */
    public DoublePoint(Point p) {
        x = p.x;
        y = p.y;
    }

    /**
     * Creates a copy of a DoublePoint.
     *
     * @param p the DoublePoint, which will be copied
     */
    public DoublePoint(DoublePoint p) {
        x = p.x;
        y = p.y;
    }

    /**
     * Creates a DoublePoint/tuple (x,y) where x and y are of type int.
     *
     * @param xi the x-coordinate
     * @param yi the y-coordinate
     */
    public DoublePoint(int xi, int yi) {
        x = xi;
        y = yi;
    }

    /**
     * Constructs and initializes a point at the origin (0, 0) of the coordinate space.
     */
    public DoublePoint() {
        x = 0;
        y = 0;
    }

    /**
     * Converts DoublePoint to Point. The x and y values are cast to int.
     *
     * @return a Point from the given DoublePoint
     */
    public Point getPoint() {
        return new Point((int) x, (int) y);
    }

    /**
     * Converts Vector of Points to Vector of DoublePoints
     * @param points Vector of Points
     * @return Vector of DoublePoints
     */
    public static Vector<DoublePoint> convertPointVector(Vector<Point> points) {
        int size = points.size();
        if (size == 0) {
            return new Vector<>();
        }
        Vector<DoublePoint> vec = new Vector<>();
        for (int i = 0; i < size; i++) {
            vec.addElement(new DoublePoint(points.elementAt(i)));
        }
        return vec;
    }

    /**
     * Converts Vector of DoublePoints to Vector of Points
     * @param points Vector of DoublePoints
     * @return Vector of Points
     */
    public static Vector<Point> convertDoublePointVector(Vector<DoublePoint> points) {
        int size = points.size();
        DoublePoint dP;
        if (size == 0) {
            return new Vector<>();
        }
        Vector<Point> vec = new Vector<>();
        for (int i = 0; i < size; i++) {
            dP = points.elementAt(i);
            vec.addElement(dP.getPoint());
        }
        return vec;
    }
}