/*
 * @(#)Command.java 5.1
 *
 */

package CH.ifa.draw.util;


import de.renew.draw.ui.ontology.AbstractCommand;

/**
 * Commands encapsulate an action to be executed. Commands have
 * a name and can be used in conjunction with <i>Command enabled</i>
 * ui components.
 * <hr>
 * <b>Design Patterns</b><P>
 * <img src="images/red-ball-small.gif" width=6 height=6 alt=" o ">
 * <b><a href=../pattlets/sld010.htm>Command</a></b><br>
 * Command is a simple instance of the command pattern without undo
 * support.
 * <hr>
 *
 * @deprecated This class is not to be used externally. Please use {@link AbstractCommand} instead.
 * {@link CommandMenu}
 * {@link CommandMenuItem}
 */
@Deprecated(forRemoval = true)
public abstract class Command extends AbstractCommand {

    /**
     * Deprecated command name. NOTE: This field will NOT be updated when the superclass changes its name.
     * It is subject to be removed.
     * Currently used here: {@link de.renew.invariantanalysis.commands.GetInvariantCommand#GetInvariantCommand(boolean)}
     */
    @SuppressWarnings("JavadocReference")
    @Deprecated
    protected String fName;

    /**
     * Constructs a command with the given name.
     * @param name the name of the command.
     */
    @Deprecated
    public Command(String name) {
        super(name);
        fName = name;
    }

    /**
     * Compatibility method to get the command name.
     * @deprecated Method has been replaced by {@link AbstractCommand#getCommandName()}
     * @return the name of the command
     */
    @Deprecated
    public String name() {
        return getCommandName();
    }

}