/*
 * @(#)TextHolder.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import de.renew.draw.storables.ontology.Figure;


/**
 * The interface of a figure that has some editable text contents.
 * <br>
 * Modifier 'public' is needed in {@link CH.ifa.draw.figures.ConnectedTextTool#mouseDown(MouseEvent, int, int)}
 * {@link Figure}
 */
public interface TextHolder {
    Rectangle textDisplayBox();

    /**
     * Gets the text shown by the text figure.
     */
    String getText();

    /**
     * Sets the text shown by the text figure.
     */
    void setText(String newText);

    /**
     * Tests whether the figure accepts typing.
     */
    boolean acceptsTyping();

    /**
     * Sets whether the figure accepts typing.
     */
    void setReadOnly(boolean isReadOnly);

    /**
     * Gets the number of rows and columns to be overlaid when the figure
     *  is edited.
     */
    Dimension overlayRowsAndColumns();

    /**
     * Gets the font.
     */
    Font getFont();
}