/**
 * SplineAttributeCommand.java
 * <br>
 * Created: Wed Dec 13 15:29:02 2000
 *
 * @author Friedrich Delgado Friedrichs, Lutz Kirsten
 * @version
 */

package CH.ifa.draw.standard;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.util.BSpline;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingView;

/**
 * The type representing a command that allows changing PolyLineFigures by changing an attribute to a given value.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class SplineAttributeCommand extends UndoableCommand {
    final String _attribute;
    final int _value;

    /**
     * Constructs a spline attribute command.
     * @param name the command name
     * @param attributeName the name of the attribute to be changed
     * @param pValue the int value "attributeName" should be set to
     */
    public SplineAttributeCommand(String name, final String attributeName, int pValue) {
        super(name);
        _attribute = attributeName;
        _value = pValue;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        DrawingView view = getEditor().view();
        if (view.selectionCount() <= 0) {
            return false;
        } else if (view.selectionCount() > 1) {
            return true;
        } else {
            return (view.selectionElements().nextElement() instanceof PolyLineFigure);
        }
    }

    @Override
    public boolean executeUndoable() {
        if (isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            DrawingView view = getEditor().view();
            Object val = _value;
            Object spline = PolyLineFigure.BSPLINE_SHAPE;
            FigureEnumeration k = view.selectionElements();
            while (k.hasMoreElements()) {
                Figure f = k.nextFigure();
                if (f instanceof PolyLineFigure) {
                    f.setAttribute("LineShape", spline);
                    if (_attribute.equals("standard")) {
                        f.setAttribute("BSplineSegments", BSpline.DEFSEGMENTS);
                        f.setAttribute("BSplineDegree", BSpline.DEFDEGREE);
                    } else {
                        f.setAttribute(_attribute, val);
                    }
                }
            }
            view.drawAll(view.getGraphics());
            return true;
        }
        return false;
    }
} // SplineAttributeCommand
