/*
 * @(#)ReverseFigureEnumerator.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.util.NoSuchElementException;
import java.util.Vector;

import CH.ifa.draw.util.ReverseVectorEnumerator;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;


/**
 * An Enumeration that enumerates a vector of figures back (size-1) to front (0).
 */
public final class ReverseFigureEnumerator implements FigureEnumeration {
    final ReverseVectorEnumerator _enumeration;

    public ReverseFigureEnumerator(Vector<Figure> v) {
        _enumeration = new ReverseVectorEnumerator(v);
    }

    /**
     * Returns true if the enumeration contains more elements; false
     * if its empty.
     */
    @Override
    public boolean hasMoreElements() {
        return _enumeration.hasMoreElements();
    }

    /**
     * Returns the next element of the enumeration. Calls to this
     * method will enumerate successive elements.
     * @exception NoSuchElementException If no more elements exist.
     */
    @Override
    public Figure nextElement() {
        return _enumeration.nextElement();
    }

    /**
     * Returns the next element casted as a figure of the enumeration. Calls to this
     * method will enumerate successive elements.
     * @exception NoSuchElementException If no more elements exist.
     */
    @Override
    public Figure nextFigure() {
        return _enumeration.nextElement();
    }
}