/*
 * @(#)Drawing.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingChangeListener;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.Storable;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.ioontology.ExtensionFileFilter;

public class NullDrawing extends FigureChangeAdapter implements Drawing, Storable, Serializable {
    /**
     * @deprecated For internal usage only, not to be used externally. Instead of calling
     * {@link StandardDrawingView#setDrawing(Drawing)} with this, call
     * {@link StandardDrawingView#setNullDrawing()}
     */
    @Deprecated
    public static final NullDrawing INSTANCE = new NullDrawing();

    // I cannot make the constructor private, because I must
    // be storable.
    public NullDrawing() {}

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void setName(String name) {}

    @Override
    public File getFilename() {
        return null;
    }

    @Override
    public void setFilename(File filename) {}

    // Always claim to backuped, so that no backups are ever made.
    @Override
    public boolean getBackupStatus() {
        return true;
    }

    @Override
    public void setBackupStatus(boolean status) {}

    @Override
    public void release() {}

    @Override
    public Rectangle displayBox() {
        return new Rectangle();
    }

    @Override
    public FigureEnumeration figures() {
        return new FigureEnumerator(new Vector<>());
    }

    @Override
    public FigureEnumeration figuresReverse() {
        return figures();
    }

    @Override
    public Figure findFigure(int x, int y) {
        return null;
    }

    @Override
    public Figure findFigure(Rectangle r) {
        return null;
    }

    @Override
    public Figure findFigure(Rectangle r, Figure without) {
        return null;
    }

    @Override
    public Figure findFigureWithout(int x, int y, Figure without) {
        return null;
    }

    @Override
    public Figure findFigureInside(int x, int y) {
        return null;
    }

    @Override
    public Figure findFigureInsideWithout(int x, int y, Figure without) {
        return null;
    }

    @Override
    public void addDrawingChangeListener(DrawingChangeListener listener) {}

    @Override
    public void removeDrawingChangeListener(DrawingChangeListener listener) {}

    @Override
    public Enumeration<DrawingChangeListener> drawingChangeListeners() {
        return new Vector<DrawingChangeListener>().elements();
    }

    @Override
    public void checkDamage() {}

    @Override
    public Figure add(Figure figure) {
        return figure;
    }

    @Override
    public Drawing add(Drawing drawing) {
        return drawing;
    }

    @Override
    public Drawing add(Drawing drawing, int x, int y) {
        return drawing;
    }

    @Override
    public void addAll(Vector<? extends Figure> newFigures) {}

    @Override
    public Figure remove(Figure figure) {
        return figure;
    }

    @Override
    public Figure orphan(Figure figure) {
        return figure;
    }

    @Override
    public void orphanAll(Vector<? extends Figure> newFigures) {}

    @Override
    public void removeAll(Vector<? extends Figure> figures) {}

    @Override
    public void removeAll() {}

    @Override
    public void replace(Figure figure, Figure replacement) {}

    @Override
    public void sendToBack(Figure figure) {}

    @Override
    public void bringToFront(Figure figure) {}

    @Override
    public void draw(Graphics g) {}

    @Override
    public void lock() {}

    @Override
    public void unlock() {}

    @Override
    public void write(StorableOutput so) {}

    @Override
    public void read(StorableInput si) {}

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public void clearModified() {}

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(0, 0);
    }

    @Override
    public String getWindowCategory() {
        return "<BUG> Null drawings";
    }

    //------------------------------------------------------------------------
    @Override
    public SimpleFileFilter getDefaultFileFilter() {
        return new NoFileFilter();
    }

    /* (non-Javadoc)
    * @see de.renew.draw.storables.ontology.Drawing#getFileFilters()
    */
    @Override
    public HashSet<ExtensionFileFilter> getImportFileFilters() {
        return new HashSet<>();
    }

    @Override
    public HashSet<ExtensionFileFilter> getExportFileFilters() {
        return new HashSet<>();
    }

    /* (non-Javadoc)
    * @see de.renew.draw.storables.ontology.Drawing#getDefaultExtension()
    */
    @Override
    public String getDefaultExtension() {
        return "";
    }

    @Override
    public void init() {}

    @Override
    public boolean isStorable() {
        return false;
    }
}