package CH.ifa.draw.standard;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;


/**
 * Merges two figure enumerations into one, so that all elements
 * of both enumerations are traversed.
 * <p>
 * MergedFigureEnumerator.java
 * Created: Thu Mar  1  2001
 * @author Michael Duvigneau
 * @deprecated This class is not to be used externally. Please use the  {@link de.renew.draw.storables.api.StorableApi} instead.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class MergedFigureEnumerator implements FigureEnumeration {
    private final FigureEnumeration _enumA;
    private final FigureEnumeration _enumB;

    /**
     * Constructs a MergedFigureEnumerator that combines two FigureEnumerations into one.
     * @param enumA first enumeration to be used in merge
     * @param enumB second enumeration to be used in merge
     * @return MergedFigureEnumerator
     * @deprecated This method is not to be used externally. Please use the method {@link de.renew.draw.storables.api.StorableApi#createMergedFigureEnumerator(FigureEnumeration, FigureEnumeration)} instead.
     */
    @Deprecated
    public MergedFigureEnumerator(FigureEnumeration enumA, FigureEnumeration enumB) {
        if (enumA == null || enumB == null) {
            throw new NullPointerException("Enumeration may not be null!");
        }

        this._enumA = enumA;
        this._enumB = enumB;
    }

    @Override
    public boolean hasMoreElements() {
        return _enumA.hasMoreElements() || _enumB.hasMoreElements();
    }

    @Override
    public Figure nextElement() {
        if (_enumA.hasMoreElements()) {
            return _enumA.nextElement();
        } else {
            return _enumB.nextElement();
        }
    }

    @Override
    public Figure nextFigure() {
        return nextElement();
    }
}