package CH.ifa.draw.standard;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.util.ColorMap;


/**
 * Creates a menu to set the initial attributes for a figure.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class InitialAttributesMenu extends JPanel {

    final AttributeFigure _prototype;
    final Color _originalFillColor;
    final Color _originalPenColor;
    final Color _originalTextColor;
    final Integer _originalArrow;
    final String _originalLineStyle;
    final Integer _originalLineWidth;

    public InitialAttributesMenu(AttributeFigure prototype) {
        _prototype = prototype;
        _originalFillColor = prototype.getFillColor();
        _originalPenColor = prototype.getFrameColor();
        _originalTextColor = (Color) prototype.getAttribute("TextColor");
        _originalArrow = (Integer) prototype.getAttribute("ArrowMode");
        _originalLineStyle = (String) prototype.getAttribute("LineStyle");
        _originalLineWidth = (Integer) prototype.getAttribute(AttributeFigure.LINE_WIDTH_KEY);

        this.add(createMenu());

        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> {
            _prototype.setAttribute("FillColor", _originalFillColor);
            _prototype.setAttribute("FrameColor", _originalPenColor);
            _prototype.setAttribute("TextColor", _originalTextColor);
            _prototype.setAttribute("ArrowMode", _originalArrow);
            _prototype.setAttribute("LineStyle", _originalLineStyle);
            _prototype.setAttribute(AttributeFigure.LINE_WIDTH_KEY, _originalLineWidth);
        });
        this.add(resetButton);
    }

    public JPanel createMenu() {
        JPanel options = new JPanel();
        options.setLayout(new GridLayout(3, 2));

        options.add(createColorMenu("Fill Color", "FillColor"));
        options.add(createColorMenu("Pen Color", "FrameColor"));
        options.add(createColorMenu("Text Color", "TextColor"));
        options.add(createArrowMenu());
        options.add(createLineStyleMenu());
        options.add(createLineWidthMenu());

        return options;
    }

    private JPanel createLineWidthMenu() {
        JPanel lineWidthPanel = new JPanel();
        lineWidthPanel.add(new JLabel("Line Width"));
        Integer[] lineWidthList = new Integer[10];
        for (int i = 0; i < 10; i++) {
            lineWidthList[i] = i + 1;
        }

        final JComboBox<Integer> comboBox = new JComboBox<>(lineWidthList);
        comboBox.addActionListener(e -> {
            if (comboBox.getSelectedItem() instanceof Integer width) {
                _prototype.setAttribute(AttributeFigure.LINE_WIDTH_KEY, width);
            }
        });
        lineWidthPanel.add(comboBox);

        return lineWidthPanel;
    }

    private JPanel createLineStyleMenu() {
        JPanel lineStylePanel = new JPanel();
        lineStylePanel.add(new JLabel("Line Style"));
        String[] lineStyleList =
            { "Normal", "Dotted", "Dashed", "Medium Dashed", "Long Dashed", "Dash-Dotted" };

        final JComboBox<String> comboBox = new JComboBox<>(lineStyleList);
        comboBox.addActionListener(e -> {
            if (comboBox.getSelectedItem() instanceof String lineStyle) {
                switch (lineStyle) {
                    case "Normal":
                        _prototype.setAttribute("LineStyle", AttributeFigure.LINE_STYLE_NORMAL);
                        break;
                    case "Dotted":
                        _prototype.setAttribute("LineStyle", AttributeFigure.LINE_STYLE_DOTTED);
                        break;
                    case "Dashed":
                        _prototype.setAttribute("LineStyle", AttributeFigure.LINE_STYLE_DASHED);
                        break;
                    case "Medium Dashed":
                        _prototype
                            .setAttribute("LineStyle", AttributeFigure.LINE_STYLE_MEDIUM_DASHED);
                        break;
                    case "Long Dashed":
                        _prototype
                            .setAttribute("LineStyle", AttributeFigure.LINE_STYLE_LONG_DASHED);
                        break;
                    case "Dash-Dotted":
                        _prototype
                            .setAttribute("LineStyle", AttributeFigure.LINE_STYLE_DASH_DOTTED);
                        break;
                }
            }
        });
        lineStylePanel.add(comboBox);

        return lineStylePanel;
    }

    private JPanel createColorMenu(String name, final String attribute) {
        JPanel colorPanel = new JPanel();
        colorPanel.add(new JLabel(name));

        int size = ColorMap.size();
        ColorComboBoxItem[] colorList = new ColorComboBoxItem[size];


        for (int i = 0; i < size; i++) {
            colorList[i] = new ColorComboBoxItem(ColorMap.color(i), ColorMap.name(i));
        }

        final JComboBox<ColorComboBoxItem> comboBox = new JComboBox<>(colorList);
        comboBox.addActionListener(e -> {
            if (comboBox.getSelectedItem() instanceof ColorComboBoxItem item) {
                _prototype.setAttribute(attribute, item.getColor());
            }
        });
        colorPanel.add(comboBox);

        return colorPanel;
    }

    private JPanel createArrowMenu() {
        JPanel arrowPanel = new JPanel();
        arrowPanel.add(new JLabel("Arrow Style"));
        String[] arrowList = { "No Arrow", "Start", "End", "Start/End" };

        final JComboBox<String> comboBox = new JComboBox<>(arrowList);
        comboBox.addActionListener(e -> {
            if (comboBox.getSelectedItem() instanceof String arrow) {
                switch (arrow) {
                    case "No Arrow":
                        _prototype.setAttribute("ArrowMode", PolyLineFigure.ARROW_TIP_NONE);
                        break;
                    case "Start":
                        _prototype.setAttribute("ArrowMode", PolyLineFigure.ARROW_TIP_START);
                        break;
                    case "End":
                        _prototype.setAttribute("ArrowMode", PolyLineFigure.ARROW_TIP_END);
                        break;
                    case "Start/End":
                        _prototype.setAttribute("ArrowMode", PolyLineFigure.ARROW_TIP_BOTH);
                        break;
                }
            }
        });
        arrowPanel.add(comboBox);

        return arrowPanel;
    }

    private static class ColorComboBoxItem {

        final Color _color;
        final String _name;

        public ColorComboBoxItem(Color color, String name) {
            _color = color;
            _name = name;
        }

        @Override
        public String toString() {
            return _name;
        }

        public Color getColor() {
            return _color;
        }
    }
}
