/*
 * @(#)HandleTracker.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.FigureHandle;


/**
 * HandleTracker implements interactions with the handles
 * of a Figure.
 *
 * See {@link SelectionTool}.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class HandleTracker extends AbstractTool {
    private final FigureHandle _anchorhandle;

    public HandleTracker(DrawingEditor editor, FigureHandle anchorHandle) {
        super(editor);
        _anchorhandle = anchorHandle;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        _anchorhandle.invokeStart(e, x, y, view());
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        _anchorhandle.invokeStep(e, x, y, _anchorX, _anchorY, view());
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        if (SwingUtilities.isRightMouseButton(e)) {
            _anchorhandle.abort(view());
        } else {
            _anchorhandle.invokeEnd(e, x, y, _anchorX, _anchorY, view());
        }
    }
}