/*
 * @(#)GridConstrainer.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Point;
import java.io.Serializable;

import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.PointConstrainer;

/**
 * Constrains a point such that it falls on a grid.
 *
 * See {@link DrawingView}.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class GridConstrainer implements PointConstrainer, Serializable {
    private final int _gridX;
    private final int _gridY;

    public GridConstrainer(int x, int y) {
        _gridX = Math.max(1, x);
        _gridY = Math.max(1, y);
    }

    /**
     * Constrains the given point.
     * @return constrained point.
     */
    @Override
    public Point constrainPoint(Point p) {
        p.x = ((p.x + _gridX / 2) / _gridX) * _gridX;
        p.y = ((p.y + _gridY / 2) / _gridY) * _gridY;
        return p;
    }

    /**
     * Gets the x offset to move an object.
     */
    @Override
    public int getStepX() {
        return _gridX;
    }

    /**
     * Gets the y offset to move an object.
     */
    @Override
    public int getStepY() {
        return _gridY;
    }
}