/*
 * @(#)FigureTransferCommand.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.util.Vector;

import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.util.Clipboard;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureSelection;

/**
 * Common base class for commands that transfer figures
 * between a drawing and the clipboard.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
abstract class FigureTransferCommand extends UndoableCommand {
    /**
     * Constructs a drawing command.
     * @param name the command name
     */
    protected FigureTransferCommand(String name) {
        super(name);
    }

    /**
     * Deletes the selection from the drawing.
     */
    protected void deleteSelection() {
        DrawingView view = getEditor().view();
        view.drawing().removeAll(view.selection());
        view.clearSelection();
    }

    /**
     * Copies the selection to the clipboard.
     */
    protected void copySelection() {
        FigureSelection selection = getEditor().view().getFigureSelection();
        Clipboard.getClipboard().setContents(selection);
    }

    /**
     * Inserts a vector of figures and translates them by the
     * given offset.
     */
    protected void insertFigures(Vector<Figure> figures, int dx, int dy) {
        DrawingView view = getEditor().view();

        view.addAll(figures);
        view.addToSelectionAll(figures);

        StandardDrawingView.moveFigures(figures, dx, dy);
        view.checkDamage();
    }
}