/*
 * @(#)ChildDragTracker.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Point;
import java.awt.event.MouseEvent;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.framework.PartialSelectableFigure;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;


/**
 * ChildDragTracker implements the dragging of a clicked
 * ChildFigure.
 *
 * See {@link SelectionTool}.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class ChildDragTracker extends DragTracker {
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(ChildDragTracker.class);

    /**
     * Tells whether we have to track the anchor figure to detect alternate
     * parent figures. If <code>false</code>, this class behaves like its
     * superclass.
     **/
    private boolean _doTracking = false;

    /**
     * Tells whether we just started the <code>doTracking</code> mode.
     * Then the first move will bring the anchor figure to the front of the
     * drawing.
     **/
    private boolean _startTracking = false;

    /**
     * Stores the original location of the anchor figure, so we can
     * compute the offset to its original parent figure later.
     **/
    private final Point _startPoint;

    /**
     * Keeps track of the last figure found behind the current position of
     * the anchor figure. The <code>lastFigure</code> is not necessarily a
     * parent figure. It may also be <code>null</code>, if there is no
     * figure at the current location.
     **/
    private Figure _lastFigure = null;

    /**
     * Stores the original parent of the anchor figure.
     **/
    private final ParentFigure _oldParent;

    /**
     * Keeps track of the current figure that could serve as alternate
     * parent for the anchor figure.
     **/
    private ParentFigure _newParent = null;

    public ChildDragTracker(DrawingEditor editor, ChildFigure anchor) {
        super(editor, anchor);
        _startPoint = anchor.center();
        _oldParent = anchor.parent();
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        _doTracking = fAnchorFigure != null && fAnchorFigure instanceof ChildFigure
            && view().selectionCount() == 1;
        _startTracking = _doTracking;
    }

    @Override
    protected void drag(int dx, int dy) {
        if (_doTracking) {
            if (_startTracking && ((dx != 0) || (dy != 0))) {
                fEditor.drawing().bringToFront(fAnchorFigure);
                _startTracking = false;
            }
            fAnchorFigure.moveBy(dx, dy);
        } else {
            super.drag(dx, dy);
        }
    }

    private void findNewParent(MouseEvent e, int x, int y) {
        Figure figure = drawing().findFigureWithout(x, y, fAnchorFigure);
        boolean selectableFigureFound = true; //figure != null;
        if (figure instanceof PartialSelectableFigure partFig) {
            selectableFigureFound = false;
            if (partFig.isModifierSelectable() && e.isAltDown()) {
                selectableFigureFound = true;
            } else if (partFig.isSelectableInRegion(x, y)) {
                selectableFigureFound = true;
            }
        }

        // select new-found figure if it is not the last selected figure
        if (selectableFigureFound && figure != _lastFigure) {
            _lastFigure = figure;
            if (figure instanceof ParentFigure && ((ChildFigure) fAnchorFigure).parent() != figure
                && ((ChildFigure) fAnchorFigure).canBeParent((ParentFigure) figure)) {
                //Toolkit.getDefaultToolkit().beep();
                _newParent = (ParentFigure) figure;
                view().clearSelection();
                view().addToSelection(_newParent);
            } else if (_newParent != null && _oldParent != null) {
                view().clearSelection();
                view().addToSelection(_oldParent);
                _newParent = null;
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        if (_doTracking) {
            findNewParent(e, x, y);
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseUp(e, x, y);
        if (_doTracking && fAnchorFigure != null) {
            Point endPoint = fAnchorFigure.center();
            if (!_startPoint.equals(endPoint)) {
                findNewParent(e, x, y);
                if (_newParent != null) {
                    LOGGER.debug("New Parent " + _newParent + "!");
                    fAnchorFigure.moveBy(_startPoint.x - endPoint.x, _startPoint.y - endPoint.y);
                    ((ChildFigure) fAnchorFigure).setParent(_newParent);
                }
            }
        }
    }
}