/*
 * @(#)ChangeConnectionEndHandle.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Point;

import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Figure;


/**
 * A handle to reconnect the end point of
 * a connection to another figure.
 */
public class ChangeConnectionEndHandle extends ChangeConnectionHandle {

    /**
     * Constructs the connection handle.
     */
    public ChangeConnectionEndHandle(Figure owner) {
        super(owner);
    }

    /**
     * Gets the end figure of a connection.
     */
    @Override
    protected Connector target() {
        return fConnection.end();
    }

    /**
     * Disconnects the end figure.
     */
    @Override
    protected void disconnect() {
        fConnection.disconnectEnd();
    }

    /**
     * Sets the end of the connection.
     */
    @Override
    protected void connect(Connector c) {
        fConnection.connectEnd(c);
    }

    /**
     * Sets the end point of the connection.
     */
    @Override
    protected void setPoint(int x, int y) {
        fConnection.endPoint(x, y);
    }

    /**
     * Returns the end point of the connection.
     */
    @Override
    public Point locate() {
        return fConnection.endPoint();
    }
}