/*
 * @(#)ChangeAttributeCommand.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Color;

import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * Command to change a named figure attribute.
 * @deprecated This class is only for internal usage and will later be made private.
 */
@Deprecated
public class ChangeAttributeCommand extends UndoableCommand {
    private final String _attribute;
    private final Object _value;

    /**
     * Constructs a change attribute command.
     *
     * @param name
     *            the command name
     * @param attributeName
     *            the name of the attribute to be changed
     * @param value
     *            the new attribute value
     * @deprecated This constructor is only for internal usage. Please use
     *             {@link de.renew.draw.ui.api.CommandApi#createChangeAttributeCommand(String, String, Object)} instead.
     */
    @Deprecated
    public ChangeAttributeCommand(String name, String attributeName, Object value) {
        super(name);
        _attribute = attributeName;
        _value = value;
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = getEditor().view();
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Object val = f.getAttribute(_attribute);

            //Check if new value is of type Color to save possible transparency values
            if (val instanceof Color && _value instanceof Color c) {
                int alphaValue = ((Color) val).getAlpha();
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alphaValue);
                f.setAttribute(_attribute, c);
            } else {
                f.setAttribute(_attribute, _value);
            }
        }
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return getEditor().view().selectionCount() > 0;
    }
}