/*
 * @(#)BoxHandleKit.java 5.1
 *
 */

package CH.ifa.draw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.api.HandleApi;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureHandle;


/**
 * A set of utility methods to create Handles for the common
 * locations on a figure's display box.
 * @deprecated This class is not to be used externally. Please use the method {@link HandleApi#createBoxHandles(Figure)} instead.
 * @see FigureHandle
 */
@Deprecated
// TBD: use anonymous inner classes (had some problems with JDK 1.1)
public class BoxHandleKit {

    /**
     * Fills the given Vector with handles at each corner of a
     * figure.
     * @deprecated This method is not to be used externally and will later be hidden.
     */
    @Deprecated
    static public void addCornerHandles(Figure f, Vector<FigureHandle> handles) {
        handles.addElement(southEast(f));
        handles.addElement(southWest(f));
        handles.addElement(northEast(f));
        handles.addElement(northWest(f));
    }

    /**
     * Fills the given Vector with handles at each corner
     * and the north, south, east, and west of the figure.
     * @deprecated This method is not to be used externally. Please use the method {@link HandleApi#createBoxHandles(Figure)} instead.
     */
    @Deprecated
    static public Vector<FigureHandle> addHandles(Figure f, Vector<FigureHandle> handles) {
        addCornerHandles(f, handles);
        handles.addElement(south(f));
        handles.addElement(north(f));
        handles.addElement(east(f));
        handles.addElement(west(f));
        return handles;
    }

    /**
     * Returns an handle in the south from the center of the figure
     * @param owner figure that gets an southHandle
     * @return handle in the south of the figure
     * @deprecated This method is not to be used externally and will later be hidden.
     */
    @Deprecated
    static public FigureHandle south(Figure owner) {
        return new SouthHandle(owner);
    }

    /**
     * Returns an handle in the southeast from the center of the figure
     * @param owner figure that gets an southeastHandle
     * @return handle in the southeast of the figure
     * @deprecated This method is not to be used externally and will later be hidden.
     */
    @Deprecated
    static public FigureHandle southEast(Figure owner) {
        return new SouthEastHandle(owner);
    }

    /**
     * Returns an handle in the southWest from the center of the figure
     * @param owner figure that gets an southWestHandle
     * @return handle in the southWest of the figure
     * @deprecated This method is not to be used externally and will later be hidden.
     */
    @Deprecated
    static public FigureHandle southWest(Figure owner) {
        return new SouthWestHandle(owner);
    }

    /**
     * Returns an handle in the north from the center of the figure
     * @param owner figure that gets an northHandle
     * @return handle in the north of the figure
     * @deprecated This method is not to be used externally and will later be hidden.
     */
    @Deprecated
    static public FigureHandle north(Figure owner) {
        return new NorthHandle(owner);
    }

    /**
     * Returns an handle in the northEast from the center of the figure
     * @param owner figure that gets an northEastHandle
     * @return handle in the northEast of the figure
     * @deprecated This method is not to be used externally and will later be hidden.
     */
    @Deprecated
    static public FigureHandle northEast(Figure owner) {
        return new NorthEastHandle(owner);
    }

    /**
     * Returns an handle in the northWest from the center of the figure
     * @param owner figure that gets an northWestHandle
     * @return handle in the northWestHandle of the figure
     * @deprecated This method is not to be used externally and will later be hidden.
     */
    @Deprecated
    static public FigureHandle northWest(Figure owner) {
        return new NorthWestHandle(owner);
    }

    /**
     * Returns an handle in the east from the center of the figure
     * @param owner figure that gets an eastHandle
     * @return handle in the east of the figure
     * @deprecated This method is not to be used externally and will later be hidden.
     */
    @Deprecated
    static public FigureHandle east(Figure owner) {
        return new EastHandle(owner);
    }

    /**
     * Returns an handle in the west from the center of the figure
     * @param owner figure that gets an westHandle
     * @return handle in the west of the figure
     * @deprecated This method is not to be used externally and will later be hidden.
     */
    @Deprecated
    static public FigureHandle west(Figure owner) {
        return new WestHandle(owner);
    }
}


/**
 * Handle in the northeast of the center of a figure.
 * @deprecated This method is not to be used externally and will later be hidden.
 */
@Deprecated
class NorthEastHandle extends LocatorHandle {
    NorthEastHandle(Figure owner) {
        super(owner, RelativeLocator.northEast());
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = owner().displayBox();
        owner().displayBox(
            new Point(r.x, Math.min(r.y + r.height, y)),
            new Point(Math.max(r.x, x), r.y + r.height));
    }
}


/**
 * Handle in the east of the center of a figure.
 * @deprecated This method is not to be used externally and will later be hidden.
 */
@Deprecated
class EastHandle extends LocatorHandle {
    EastHandle(Figure owner) {
        super(owner, RelativeLocator.east());
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = owner().displayBox();
        owner().displayBox(new Point(r.x, r.y), new Point(Math.max(r.x, x), r.y + r.height));
    }
}


/**
 * Handle in the north of the center of a figure.
 * @deprecated This method is not to be used externally and will later be hidden.
 */
@Deprecated
class NorthHandle extends LocatorHandle {
    NorthHandle(Figure owner) {
        super(owner, RelativeLocator.north());
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = owner().displayBox();
        owner().displayBox(
            new Point(r.x, Math.min(r.y + r.height, y)), new Point(r.x + r.width, r.y + r.height));
    }
}


/**
 * Handle in the northwest of the center of a figure.
 * @deprecated This method is not to be used externally and will later be hidden.
 */
@Deprecated
class NorthWestHandle extends LocatorHandle {
    NorthWestHandle(Figure owner) {
        super(owner, RelativeLocator.northWest());
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = owner().displayBox();
        owner().displayBox(
            new Point(Math.min(r.x + r.width, x), Math.min(r.y + r.height, y)),
            new Point(r.x + r.width, r.y + r.height));
    }
}


/**
 * Handle in the southeast of the center of a figure.
 * @deprecated This method is not to be used externally and will later be hidden.
 */
@Deprecated
class SouthEastHandle extends LocatorHandle {
    private float _ratio = 1;

    SouthEastHandle(Figure owner) {
        super(owner, RelativeLocator.southEast());
        if (owner.displayBox().width != 0) {
            _ratio = ((float) owner.displayBox().height) / ((float) owner.displayBox().width);
        }
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = owner().displayBox();
        int mx = Math.max(r.x, x);
        int my = Math.max(r.y, y);
        if (e.isControlDown() && _ratio != 0) {
            owner().displayBox(
                new Point(r.x, r.y),
                new Point(mx, mx - owner().displayBox().x + owner().displayBox().y));
        } else if (e.isShiftDown()) {
            owner().displayBox(
                new Point(r.x, r.y),
                new Point(mx, Math.max(r.y, Math.round((x - r.x) * _ratio + r.y))));
        } else {
            owner().displayBox(new Point(r.x, r.y), new Point(mx, my));
        }
    }
}


/**
 * Handle in the south of the center of a figure.
 * @deprecated This method is not to be used externally and will later be hidden.
 */
@Deprecated
class SouthHandle extends LocatorHandle {
    SouthHandle(Figure owner) {
        super(owner, RelativeLocator.south());
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = owner().displayBox();
        owner().displayBox(new Point(r.x, r.y), new Point(r.x + r.width, Math.max(r.y, y)));
    }
}


/**
 * Handle in the southwest of the center of a figure.
 * @deprecated This method is not to be used externally and will later be hidden.
 */
@Deprecated
class SouthWestHandle extends LocatorHandle {
    SouthWestHandle(Figure owner) {
        super(owner, RelativeLocator.southWest());
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = owner().displayBox();
        owner().displayBox(
            new Point(Math.min(r.x + r.width, x), r.y), new Point(r.x + r.width, Math.max(r.y, y)));
    }
}


/**
 * Handle in the west of the center of a figure.
 * @deprecated This method is not to be used externally and will later be hidden.
 */
@Deprecated
class WestHandle extends LocatorHandle {
    WestHandle(Figure owner) {
        super(owner, RelativeLocator.west());
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = owner().displayBox();
        owner().displayBox(
            new Point(Math.min(r.x + r.width, x), r.y), new Point(r.x + r.width, r.y + r.height));
    }
}