package CH.ifa.draw.io;

import java.io.File;
import java.util.*;
import javax.swing.JMenu;

import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.exportFormats.ExportFormatMapper;
import de.renew.draw.storables.impl.drawings.DrawingExportFormatHolder;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.impl.menus.ExportMenuHolder;
import de.renew.draw.ui.ontology.StatusDisplayer;


/**
 * Maintains a list of all known export formats ({@link ExportFormat})
 * by implementing the {@link ExportHolder} interface.
 * Also generates the Export menu ({@link #getExportMenu()})
 * and offers convenience methods to export to a specific format.
 * @deprecated This type is not to be used externally and will later be removed.
 * Please use the methods offered by the {@link de.renew.draw.storables.api.StorableApi}
 * for the registration and deregistration of drawing export formats instead.
 */
@Deprecated(since = "5.0", forRemoval = true)
@SuppressWarnings("removal")
public class ExportHolderImpl implements ExportHolder {
    /**
     * Creates log4j Logger for this class to represent logging information.
     */
    public static org.apache.log4j.Logger logger =
        org.apache.log4j.Logger.getLogger(ExportHolderImpl.class);

    /**
     * The instance of the ExportMenuHolder that manages the import menu of the application.
     */
    private final ExportMenuHolder _exportMenuHolder;

    /**
     * Constructs and initializes ExportHolder with a new command menu.
     */
    public ExportHolderImpl() {
        _exportMenuHolder = new ExportMenuHolder();
    }


    /**
     * Returns the export menu for the export holder.
     *
     * @return the export menu
     */
    public JMenu getExportMenu() {
        return _exportMenuHolder.getExportMenu();
    }

    //	---------------------------------------------------------------------
    // Implementation of the ExportHolder Interface
    // ---------------------------------------------------------------------

    /**
      * Save an enumeration of drawings with the help of format (n to 1).
      * @require format != null.
      * @require drawings != null
      * @require path != null
      * @param drawings the enumeration of drawings to be saved
      * @param format the format in which the enumeration is to be saved
      * @param path the filename of the file the enumeration is to be saved to
      * @param displ the StatusDisplayer the export message will be shown in
      */
    public void saveDrawings(
        Enumeration<Drawing> drawings, ExportFormat format, File path, StatusDisplayer displ)
    {
        try {
            ArrayList<Drawing> list2 = Collections.list(drawings);
            Drawing[] array = list2.toArray(new Drawing[0]);
            format.export(array, path);
            displ.showStatus("Exported " + path.getPath() + ".");
        } catch (Exception e) {
            logger.error(e.getMessage());
            displ.showStatus(e.toString());
            if (logger.isDebugEnabled()) {
                logger.debug(ExportHolderImpl.class.getSimpleName() + ": ", e);
            }
        }
    }



    /**
     * Save an array of drawings with the help of format.
     * @require drawing != null
     * @require format != null
     * @require path != null
     * @param drawing The drawing to be saved
     * @param format The format in which the drawing is to be saved
     * @param path The filename of the file the drawing is to be saved to
     * @param sd The StatusDisplayer the export message will be shown in
     */
    public void saveDrawing(Drawing drawing, ExportFormat format, File path, StatusDisplayer sd) {
        try {
            File pathResult = format.export(drawing, path);
            sd.showStatus("Exported " + pathResult.getPath() + ".");
        } catch (Exception e) {
            sd.showStatus(e.getMessage());
            e.printStackTrace();
        }
    }



    @Override
    public void addExportFormat(ExportFormat exportFormat) {
        DrawingExportFormatHolder.getInstance()
            .addExportFormat(ExportFormatMapper.mapExportFormat(exportFormat));
    }

    @Override
    public ExportFormat[] allExportFormats() {
        return DrawingExportFormatHolder.getInstance().getExportFormats().stream()
            .map(ExportFormatMapper::mapExportFormat).toArray(ExportFormat[]::new);
    }

    @Override
    public void removeExportFormat(ExportFormat format) {
        DrawingExportFormatHolder.getInstance()
            .removeExportFormat(ExportFormatMapper.mapExportFormat(format));
    }



}