package CH.ifa.draw.framework;

import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.DrawingEditor;

/**
 * An abstract superclass for commands whose effects
 * should be undoable. Before the command's body is
 * executed, an undo snapshot of the currently active
 * drawing will be appended to the undo history.
 * <p>
 * The undo mechanism covers modification of figures only.
 * This does not include the selection state.
 * </p>
 * UndoableCommand.java
 * Created: Wed Dec 6  2000
 * @author Julia Hagemeister, Michael Duvigneau
 *
 * @see CH.ifa.draw.framework.UndoRedoManager
 */
public abstract class UndoableCommand extends AbstractCommand {
    //    private DrawingEditor fEditor;

    /**
     * Constructs a command with the given name.
     * @param name name of command to be constructed
     */
    public UndoableCommand(String name) {
        super(name);
        // fEditor = editor;
    }

    /**
     * Executes the command.
     * This method should not be overridden by subclasses
     * unless they care about taking snapshots on their own.
     * Use executeUndoable() instead.
     * @see #executeUndoable
     **/
    @Override
    public void execute() {
        DrawingEditor editor = getEditor();
        editor.prepareUndoSnapshot();
        boolean changed = executeUndoable();
        if (changed) {
            editor.commitUndoSnapshot();
        }
        /*else {fEditor.forgetUndoSnapshot();} */

    }

    /**
     * Gets the current drawing editor.
     * @return drawing editor
     */
    protected DrawingEditor getEditor() {
        return EditorApi.getCurrentEditor();
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return getEditor() != EditorApi.getNullDrawingEditor();
    }

    /**
     * Executes the command.
     * This method should contain the core functionality,
     * it is called by execute().
     * An undo snapshot has already been taken when this
     * method is called.
     *
     * @return <code>true</code> if the drawing's figures were modified,
     *         <code>false</code> otherwise.
     */
    protected abstract boolean executeUndoable();
}