/*
 * @(#)RadiusHandle.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import org.freehep.graphicsio.VectorGraphicsIO;

import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * A Handle to manipulate the radius of a round corner rectangle.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
class RadiusHandle extends AbstractHandle {
    private static final int OFFSET = 3;
    private Point _radius;
    private final RoundRectangleFigure _owner;

    public RadiusHandle(RoundRectangleFigure owner) {
        super(owner);
        _owner = owner;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        _radius = _owner.getArc();
        _radius.x = _radius.x / 2;
        _radius.y = _radius.y / 2;
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        int dx = x - anchorX;
        int dy = y - anchorY;
        Rectangle r = _owner.displayBox();
        int rx = Geom.range(0, r.width, 2 * (_radius.x + dx));
        int ry = Geom.range(0, r.height, 2 * (_radius.y + dy));
        _owner.setArc(rx, ry);
    }

    @Override
    public Point locate() {
        Point radius = _owner.getArc();
        Rectangle r = _owner.displayBox();
        return new Point(r.x + radius.x / 2 + OFFSET, r.y + radius.y / 2 + OFFSET);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = displayBox();

        g.setColor(Color.yellow);
        //we need to draw vector graphics differently for svg and java
        if (g instanceof VectorGraphicsIO) {
            g.fillOval(r.x + 1, r.y + 1, r.width - 1, r.height - 1);
        } else {
            g.fillOval(r.x, r.y, r.width, r.height);
        }
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}