/*
 * @(#)LineFigure.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Point;
import java.io.Serial;

/**
 * A line figure.
 */
public class LineFigure extends PolyLineFigure {
    /*
     * Serialization support.
     */
    @Serial
    private static final long serialVersionUID = 511503575249212371L;

    /**
     * Unused serial version number
     */
    @SuppressWarnings("unused")
    private final int _lineFigureSerializedDataVersion = 1;

    /**
     * Constructs a LineFigure with both start and end set to Point(0,0).
     */
    public LineFigure() {
        addPoint(0, 0);
        addPoint(0, 0);
    }

    /**
     * Gets a copy of the start point.
     *
     * @return Point at index 0 of Point Vector
     */
    public Point startPoint() {
        return pointAt(0);
    }

    /**
     * Gets a copy of the end point.
     *
     * @return Point at index 1 of Point Vector
     */
    public Point endPoint() {
        return pointAt(1);
    }

    /**
     * Sets the start point.
     *
     * @param x will be the x coordinate of new start point
     * @param y will be the y coordinate of new start point
     */
    public void startPoint(int x, int y) {
        setPointAt(new Point(x, y), 0);
    }

    /**
     * Sets the end point.
     *
     * @param x will be the x coordinate of new end point
     * @param y will be the y coordinate of new end point
     */
    public void endPoint(int x, int y) {
        setPointAt(new Point(x, y), 1);
    }

    /**
     * Sets the start and end point.
     *
     * @param start new start point
     * @param end new end point
     */
    public void setPoints(Point start, Point end) {
        setPointAt(start, 0);
        setPointAt(end, 1);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        setPoints(origin, corner);
    }
}