/*
 * @(#)GroupFigure.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serial;
import java.util.Vector;

import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.FigureHandle;

/**
 * A Figure that groups a collection of figures.
 */
public class GroupFigure extends CompositeFigure {
    /*
     * Serialization support.
     */
    @Serial
    private static final long serialVersionUID = 8311226373023297933L;

    /**
     * Unused serial version number
     */
    @SuppressWarnings("unused")
    private final int _groupFigureSerializedDataVersion = 1;

    /**
     * Creates a new {@code GroupFigure}
     */
    public GroupFigure() {
        super();
    }

    /**
     * GroupFigures cannot be connected
     */
    @Override
    public boolean canConnect() {
        return false;
    }

    /**
     * Gets the display box. The display box is defined as the union
     * of the contained figures.
     */
    @Override
    public Rectangle displayBox() {
        FigureEnumeration k = figures();
        Rectangle r = k.nextFigure().displayBox();

        while (k.hasMoreElements()) {
            r.add(k.nextFigure().displayBox());
        }
        return r;
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        // only move.
        // we could transform all components proportionally
        Rectangle box = displayBox();
        basicMoveBy(origin.x - box.x, origin.y - box.y);
    }

    @Override
    public FigureEnumeration decompose() {
        return new FigureEnumerator(fFigures);
    }

    /**
     * Gets the handles for the GroupFigure.
     */
    @Override
    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<>();
        handles.addElement(new GroupHandle(this, RelativeLocator.northWest()));
        handles.addElement(new GroupHandle(this, RelativeLocator.northEast()));
        handles.addElement(new GroupHandle(this, RelativeLocator.southWest()));
        handles.addElement(new GroupHandle(this, RelativeLocator.southEast()));
        return handles;
    }

    /**
     * Sets the attribute of all the contained figures.
     */
    @Override
    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        FigureEnumeration k = figures();
        while (k.hasMoreElements()) {
            k.nextFigure().setAttribute(name, value);
        }
    }
}