/*
 * @(#)GroupCommand.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.util.Vector;

import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * Command to group the selection into a GroupFigure.
 *
 * @deprecated This class is only for internal usage and will later be made private.
 * @see GroupFigure
 */
@Deprecated
public class GroupCommand extends UndoableCommand {
    // protected DrawingEditor fEditor;

    /**
     * Constructs a group command.
     * @param name the command name
     * @deprecated This constructor is only for internal usage. Please use
     *             {@link de.renew.draw.ui.api.CommandApi#createGroupCommand(String)} instead.
     */
    @Deprecated
    public GroupCommand(String name) {
        super(name);
        // fEditor = editor;
    }

    @Override
    public boolean executeUndoable() {
        DrawingView view = getEditor().view();
        Vector<Figure> selected = view.selectionZOrdered();
        Drawing drawing = view.drawing();
        if (!selected.isEmpty()) {
            view.clearSelection();
            drawing.orphanAll(selected);

            GroupFigure group = new GroupFigure();
            group.addAll(selected);
            view.addToSelection(drawing.add(group));
            view.checkDamage();
            return true;
        }
        return false;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return getEditor().view().selectionCount() > 0;
    }
}