/*
 * @(#)BorderDecorator.java 5.1
 *
 */

package CH.ifa.draw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serial;

import CH.ifa.draw.standard.DecoratorFigure;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;

/**
 * BorderDecorator decorates an arbitrary Figure with
 * a border.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
@SuppressWarnings("removal")
public class BorderDecorator extends DecoratorFigure {
    /*
     * Serialization support.
     */
    @Serial
    private static final long serialVersionUID = 1205601808259084917L;

    /**
     * Unused serial version number.
     */
    @SuppressWarnings("unused")
    private final int _borderDecoratorSerializedDataVersion = 1;

    /**
     * Constructs a new BorderDecorator.
     */
    public BorderDecorator() {}

    /**
     * Constructs a new BorderDecorator and sets the Figure that is decorated with a border.
     *
     * @param figure Figure that is decorated
     */
    public BorderDecorator(Figure figure) {
        super(figure);
    }

    private Point border() {
        return new Point(3, 3);
    }

    /**
     * Draws the figure and decorates it with a border.
     */
    @Override
    public void draw(Graphics g) {
        Rectangle r = displayBox();
        super.draw(g);
        g.setColor(Color.white);
        g.drawLine(r.x, r.y, r.x, r.y + r.height);
        g.drawLine(r.x, r.y, r.x + r.width, r.y);
        g.setColor(Color.gray);
        g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
    }

    /**
     * Gets the display-box including the border.
     */
    @Override
    public Rectangle displayBox() {
        Rectangle r = fComponent.displayBox();
        r.grow(border().x, border().y);
        return r;
    }

    /**
     * Invalidates the figure extended by its border.
     */
    @Override
    public void figureInvalidated(FigureChangeEvent e) {
        Rectangle rect = e.getInvalidatedRectangle();
        rect.grow(border().x, border().y);
        super.figureInvalidated(StorableApi.createFigureChangeEvent(e.getFigure(), rect));
    }

    @Override
    public Insets connectionInsets() {
        Insets i = super.connectionInsets();
        i.top -= 3;
        i.bottom -= 3;
        i.left -= 3;
        i.right -= 3;
        return i;
    }
}