/*
 * Fri Feb 28 07:47:05 1997  Doug Lea  (dl at gee)
 * Based on ScribbleTool
 */

package CH.ifa.draw.contrib;

import java.awt.Point;
import java.awt.event.MouseEvent;

import CH.ifa.draw.standard.UndoableTool;
import de.renew.draw.ui.ontology.DrawingEditor;


/**
 * A tool to create a new polygon figure.
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
public class PolygonTool extends UndoableTool {
    private PolygonFigure _polygon;
    private int _lastX;
    private int _lastY;

    /**
     * Constructs a {@link PolygonTool} for the given editor.
     * @param editor the drawing editor that this tool belongs to
     */
    public PolygonTool(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void activate() {
        super.activate();
        _polygon = null;
    }

    @Override
    public void deactivate() {
        if (_polygon != null) {
            _polygon.smoothPoints();
            if (_polygon.pointCount() < 3 || _polygon.size().width < 4
                || _polygon.size().height < 4) {
                drawing().remove(_polygon);
                noChangesMade();
            }
        }
        _polygon = null;
        super.deactivate();
    }

    private void addPoint(int x, int y) {
        if (_polygon == null) {
            _polygon = new PolygonFigure(x, y);
            view().add(_polygon);
            _polygon.addPoint(x, y);
            changesMade();
        } else if (_lastX != x || _lastY != y) {
            _polygon.addPoint(x, y);
        }

        _lastX = x;
        _lastY = y;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        // replace pts by actual event pts
        // I don't know why this was originally done, but we want to explicitly NOT do this
        // in order to not break the zooming feature
        //        x = e.getX();
        //        y = e.getY();
        if (e.getClickCount() >= 2) {
            if (_polygon != null) {
                _polygon.smoothPoints();
                editor().toolDone();
            }
            _polygon = null;

        } else {
            // use original event coordinates to avoid
            // suppress that the scribble is constrained to
            // the grid
            // EDIT: For the zooming feature to work we DO need the
            // transformed coordinates
            addPoint(x, y);
        }
    }

    @Override
    public void mouseMove(MouseEvent e, int x, int y) {
        if (_polygon != null) {
            if (_polygon.pointCount() > 1) {
                _polygon.setPointAt(new Point(x, y), _polygon.pointCount() - 1);
                view().checkDamage();
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        // replace pts by actual event pts
        //        x = e.getX();
        //        y = e.getY();
        addPoint(x, y);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {}
}