/*
 * Sat Mar  1 09:06:09 1997  Doug Lea  (dl at gee)
 * Based on RadiusHandle
 */

package CH.ifa.draw.contrib;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import de.renew.draw.ui.ontology.DrawingView;


/**
 * A Handle to scale and rotate a PolygonFigure
 * @deprecated This class is not to be used externally and will later be hidden.
 */
@Deprecated(since = "5.0", forRemoval = true)
class PolygonScaleHandle extends AbstractHandle {
    private Point _origin = null;
    private Point _current = null;
    private Polygon _origPoly = null;

    public PolygonScaleHandle(PolygonFigure owner) {
        super(owner);
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        _origPoly = ((PolygonFigure) (owner())).getPolygon();
        _origin = getOrigin();
        _current = new Point(_origin.x, _origin.y);
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        int dx = x - anchorX;
        int dy = y - anchorY;
        boolean scale = true;
        boolean rotate = true;
        _current = new Point(_origin.x + dx, _origin.y + dy);
        if (e.isControlDown()) {
            rotate = false;
        } else if (e.isShiftDown()) {
            scale = false;
        }
        ((PolygonFigure) (owner())).scaleRotate(_origin, _origPoly, _current, scale, rotate);
        view.selectionInvalidateHandles();
    }

    @Override
    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        super.invokeEnd(x, y, anchorX, anchorY, view);
        _origPoly = null;
        _origin = null;
        _current = null;
    }

    @Override
    public Point locate() {
        if (_current != null) {
            return _current;
        } else {
            return getOrigin();
        }
    }

    Point getOrigin() { // find a nice place to put handle
        Point outer = ((PolygonFigure) (owner())).outermostPoint();
        Point ctr = ((owner())).center();
        double len = Geom.length(outer.x, outer.y, ctr.x, ctr.y);
        if (len == 0) { // best we can do?
            return new Point(outer.x - HANDLESIZE / 2, outer.y + HANDLESIZE / 2);
        }

        double u = HANDLESIZE / len;
        if (u > 1.0) { // best we can do?
            return new Point((outer.x * 3 + ctr.x) / 4, (outer.y * 3 + ctr.y) / 4);
        } else {
            return new Point(
                (int) (outer.x * (1.0 - u) + ctr.x * u), (int) (outer.y * (1.0 - u) + ctr.y * u));
        }
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = displayBox();

        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);

        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);


        //for debugging ...

        /*
        Point ctr = ((PolygonFigure) (owner())).center();
        g.setColor(Color.blue);
        g.fillOval(ctr.x, ctr.y, r.width, r.height);
        
        g.setColor(Color.black);
        g.drawOval(ctr.x, ctr.y, r.width, r.height);
        */
    }
}