package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import de.renew.draw.ui.ontology.AbstractCommand;


/**
 * A command that opens a drawing fetched from some URL in the editor.
 *
 * @author Michael Duvigneau
 **/
public class OpenURLCommand extends AbstractCommand {
    /**
     * Constructs a command with the name "Open URL...".
     */
    public OpenURLCommand() {
        super("Open URL...");
    }

    /**
     * This command is always executable.
     * <p>
     * It is of course not executable when there is no gui open, but then
     * the command is not accessible, either.
     * </p>
     * @return always <code>true</code>
     **/
    @Override
    public final boolean isExecutable() {
        return true;
    }

    /**
     * Opens a drawing fetched from some URL.
     **/
    @Override
    public final void execute() {
        DrawPlugin.getGui().promptOpenURL();
    }
}