package CH.ifa.draw.application;

import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager.SeparatorFactory;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.ImportHolderImpl;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;
import CH.ifa.draw.util.UpdatableCommandMenuItem;
import de.renew.draw.ui.impl.menus.internal.MenuHelper;

/**
 * Providing functionality to create the FileMenu.
 */
public class FileMenuCreator {

    /**
     * The property name {@value}. Controls whether the settings menu for plugins should be listed.
     */
    public static final String PLUGIN_SETTINGS_MENU_PROP_NAME = "de.renew.pluginSettingsMenu";
    /**
     * Retrieve a logger named according to the value of the name parameter.
     * If the named logger already exists, then the existing instance will be returned.
     * Otherwise, a new instance is created.
     */
    public static org.apache.log4j.Logger logger =
        org.apache.log4j.Logger.getLogger(FileMenuCreator.class);

    private UpdatableCommandMenuItem defaultMenuItem = null;

    /**
     * This is the default constructor.
     */
    public FileMenuCreator() {}

    /**
     * Returns a Collection containing the newly created JMenuItems.
     * @param exportHolder list of all supported export formats
     * @param importHolder list of all supported import formats
     * @param recentlySavedMenu menu which lists the recently saved files
     * @return Collection of JMenuItems that were created
     */
    public Collection<JMenuItem> createMenus(
        ImportHolderImpl importHolder, ExportHolderImpl exportHolder, CommandMenu recentlySavedMenu)
    {
        Vector<JMenuItem> result = new Vector<JMenuItem>();
        SeparatorFactory sepFac = new SeparatorFactory("ch.ifa.draw");

        if (defaultMenuItem == null) {
            defaultMenuItem =
                new UpdatableCommandMenuItem(new NewDefaultDrawingCommand(), KeyEvent.VK_N);
        }
        result.add(defaultMenuItem);
        result.add(new CommandMenuItem(new NewDrawingCommand()));

        result.add(sepFac.createSeparator());

        result.add(new CommandMenuItem(new OpenURLCommand()));
        result.add(new CommandMenuItem(new OpenDrawingCommand(), KeyEvent.VK_O));
        result.add(new CommandMenuItem(new InsertDrawingCommand()));
        result.add(new CommandMenuItem(new SaveDrawingCommand(), KeyEvent.VK_S));
        result.add(
            new CommandMenuItem(
                new SaveDrawingAsCommand(), KeyEvent.VK_S,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + InputEvent.SHIFT_DOWN_MASK));
        result.add(new CommandMenuItem(new SaveAllDrawingsCommand()));
        result.add(new CommandMenuItem(new CloseDrawingCommand(), KeyEvent.VK_W));
        result.add(
            new CommandMenuItem(
                new CloseAllDrawingsCommand(), KeyEvent.VK_W,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + InputEvent.SHIFT_DOWN_MASK));

        result.add(recentlySavedMenu);

        result.add(sepFac.createSeparator());

        result.add(importHolder.getImportMenu());
        result.add(exportHolder.getExportMenu());

        result.add(sepFac.createSeparator());

        result.add(new CommandMenuItem(new PrintDrawingCommand()));

        result.add(sepFac.createSeparator());

        result.add(MenuHelper.createMenuItem("Exit", this::exit));

        return result;
    }

    private void exit() {
        DrawApplication app = DrawPlugin.getGui();

        //app.requestClose();
        // TODO:
        // This is a terrible hack and should be removed asap.
        // In fact the whole file menu should be moved to the windowmanagement plugin.
        // This requires work though.
        JFrame frame = app.getFrame();
        frame.dispatchEvent(new WindowEvent(frame, WindowEvent.WINDOW_CLOSING));
    }
}