# CH

The CH package provides a massively modified version of the JHotDraw
drawing editor.
The main class, `CH.ifa.draw.DrawPlugin`, provides several interface methods
that can be used by other plugins to extend the functionality.
Right now, those objects include:

## Menu Handling
### a) Menu commands
To add a menu to the JHotDraw Gui, you use the MenuApi interface, an
instance of which can be obtained by the `getMenuApi()` method of the
current DrawPlugin.  

It is VERY IMPORTANT that the menu/menu item you are
registering identifies itself, or it will not be added.
The identification is done by using the `putClientProperty()`; the key String
to use as its first parameter must be `ch.ifa.draw.menu.id` (which is
stored as the String constant `MenuApi.ID_PROPERTY`).
The object to be put into this property (i.e., the second parameter) must
be a unique String (it is encouraged to use your plugin's provision as a
prefix).  You must keep your menu object referenced so you can unregister
it again when your plugin is unloaded.  If removing a previously registered
menu causes its parent menu to become empty, that parent is also removed.

To create a separator in a menu, you must create a pseudo JMenuItem to
register it.  This Separator can be obtained by the
`MenuManager.SeparatorFactory`
inner class.  It is instantiated by a String containing the prefix that you
use for your `ID_PROPERTY`. Separators need (and can) not be unregistered;
rather, they are removed automatically.

- `registerMenu(String toplevel, JMenuItem toAdd)`- add the given Menu Item to the parent menu with the given label. If such a parent is not present, one is created.
- `unregisterMenu(JMenuItem item)`- remove given item from the menu it is in. The item will be identified by the item's ID_PROPERTY. If removing the item causes a separator to become top item of the parent menu, that separator will be removed.

### b) Windows menu entries
The DrawApplication automatically takes care that all open drawings are
added to the windows menu (and removed, respectively).  The drawings are
ordered in categories, the category is retrieved via the method `getCategory`
in the Drawing interface.

Other windows that should appear in the Windows menu must be registered
explicitly at the new MenuAPI via these static methods.

- `registerWindowsMenuDialog(category, dialog)` - Adds a (hopefully non-modal) dialog to the windows menu under the given category.
- `registerWindowsMenuFrame(category, frame)`- Register a window with the menu. Should be called every time a window is opened. The window title is used as menu entry.
- `unregisterWindowsMenuDialog(dialog)` - Adds a frame to the windows menu under the given category.
- `unregisterWindowsMenuFrame(frame)`- Deregister a window from the menu. Should be called every time a window is closed.

Direct calls to CH.ifa.draw.application.WindowsMenu are now deprecated.

Many tool dialogs might register themselves under the Tools category,
which is defined as a constant, accessible via 
`getWindowsCategoryNameTools()`

## Input/output

- `getIOHelper()`- the CH.ifa.draw.IOHelper Singleton collects all methods concerning the loading and saving of files; `getLoadPath(),` `loadAndOpenDrawing()`, and so on. Check its Javadoc for more information.

## Drawing Access
- `getDrawingEditor()`  - returns the drawing editor (the main window if active, or a pseudo editor object)

## Import/export
Renew allows registering formats for exporting drawings into files and importing files into drawings. 

Additional formats can be realized by implementing the interfaces `ExportFormat` / `ImportFormat` and their subtypes. 
They then can be registered using the methods provided by the `StorableApi`, ideally during the initialization of the plugin they are implemented in. 
When that plugin is unloaded, the formats should be unloaded as well, using again the methods of the `StorableApi`.

## Used Properties
(For default values, see plugin.cfg)

**NAME**|**TYPE**|**Description** 
:-----|:-----|:-----
`de.renew.loadServerPort`|`int`|Interprets the value of a system property to determine if a drawing load server should be started. |
`de.renew.defaultFontSize` | `int` | Interprets the value of a system property to determine the font size for new text figures.
`de.renew.menuFontSize` | `int` | Interprets the value of a system property to determine the font size for the application menus.
`de.renew.defaultFontName` | `String` | Returns the default fontname.
`ch.ifa.draw.num-of-recent-files` | `int` | Number of drawings listed in the recently saved menu (dynamically checked)
`de.renew.windowResizable` | `boolean` | Interprets the value of a system property to determine if the main menu frame should be resizable.
`de.renew.avoidFrameReshape` | `boolean` | Interprets the value of a system property to determine if frames may be positioned or sized.
`de.renew.customToolBorders` | `boolean` | Interprets the value of a system property to determine if toolbar buttons should be painted with selfmade shadow borders.
`de.renew.noGraphics` | `boolean`| Interprets the value of a system property to determine whether graphics will be in use when loading a drawing.
`ch.ifa.draw.show-recentlysaved-hotkeys` | `boolean` | allow hotkeys for recently saved files (must be available at start-up)
`ch.ifa.draw.window-focus-workaround` | `boolean` | workaround to bring window frames to front on certain os (must be available at start-up)
`ch.ifa.draw.polygon.smoothing` | `Typ` | smoothing strategy of polygon figure (alignment (default), distances, off)
`ch.ifa.draw.grid.size` | `int` |
`ch.ifa.draw.grid.default` | `boolean` |

use upper case letters for sticky function
use Selection Tool to undo sticky function
use name of tool as suffix to define new map entries
(be careful not to use duplicate keys)
`de.renew.keymap.use-mapping`
`de.renew.keymap.Selection_Tool`
`de.renew.keymap.Transition_Tool`
`de.renew.keymap.Place_Tool`
`de.renew.keymap.Virtual_Place_Tool`
`de.renew.keymap.Test_Arc_Tool`
`de.renew.keymap.Reserve_Arc_Tool`
`de.renew.keymap.Flexible_Arc_Tool`
`de.renew.keymap.Inscription_Tool`
`de.renew.keymap.Name_Tool`|`Typ`
`de.renew.keymap.Declaration_Tool`


## Included Packages
- `CH.ifa.draw.framework`
- `CH.ifa.draw.standard`
- `CH.ifa.draw.figures`
- `CH.ifa.draw.util`
- `CH.ifa.draw`
- `CH.ifa.draw.io`
- `CH.ifa.draw.application`
- `CH.ifa.draw.io.importFormats`
- `CH.ifa.draw.io.exportFormats`
- `CH.ifa.draw.contrib`
- `de.renew.draw.api`

## Provided Commands
- `CH.ifa.draw.application.CloseDrawingCommand`
- Numerous commands that implement `de.renew.draw.ui.ontology.AbstractCommand`, which can be used in conjunction with ui components.

## Public Interfaces
- `de.renew.draw.ui.ontology.DrawingViewContainer` - view container for a drawing
- `CH.ifa.draw.application.DrawingViewContainerListener`
- `CH.ifa.draw.application.DrawingViewContainerSupplier`
- `CH.ifa.draw.contrib.OutlineFigure`
- `CH.ifa.draw.figures.LineDecoration`
- `CH.ifa.draw.figures.PolyLineable`
- `CH.ifa.draw.framework.ChildFigure`
- `de.renew.draw.storables.ontology.ConnectionFigure` - Figures to connect Connectors provided by Figures
- `de.renew.draw.storables.ontology.Connector` - connectors know how to locate a connection point on a figure
- `de.renew.draw.storables.ontology.Drawing` -  drawing is a container for figures 
- `de.renew.draw.storables.ontology.DrawingChangeListener` - listener interested in Drawing changes
- `de.renew.draw.ui.ontology.FigureDrawingContext` - Interface to manage the drawing context of a figure.
- `de.renew.draw.ui.ontology.DrawingEditor` - drawingEditor defines the interface for coordinating the different objects that participate in a drawing editor
- `CH.ifa.draw.framework.DrawingTypeManagerListener` - listeners of this type can be registered at `DrawingTypeManager` and are informed about changes in the set of known drawing types
- `de.renew.draw.ui.ontology.DrawingView` - drawingView renders a Drawing and listens to its changes
- `CH.ifa.draw.framework.DrawingViewDecoration` - classes implementing this interface provide some decorations which can be added to a DrawingView
- `de.renew.draw.storables.ontology.Figure` - the interface of a graphical figure
- `de.renew.draw.storables.ontology.FigureChangeListener` - listener interested in Figure changes
- `de.renew.draw.storables.ontology.FigureChangeEvent` - FigureChange event passed to FigureChangeListeners.
- `de.renew.draw.storables.ontology.FigureEnumeration` - interface for Enumerations that access Figures
- `de.renew.draw.storables.ontology.FigureFilter` - interface for filtering figures
- `de.renew.draw.storables.ontology.FigureWithDependencies` - Tags figures which depend on other figures or are needed by other figures. The information from this interface is used to expand the selection when cut, copy or duplicate facilities are used
- `CH.ifa.draw.framework.FigureWithID` - Figures providing identification by an ID
- `de.renew.draw.ui.ontology.FigureHandle` - Handles are used to change a figure by direct manipulation
- `de.renew.draw.storables.ontology.Locator` - Locators can be used to locate a position on a figure
- `de.renew.draw.ui.ontology.Painter` - Painter defines the interface for drawing a layer into a DrawingView
- `CH.ifa.draw.framework.ParentFigure`
- `CH.ifa.draw.framework.PartialSelectableFigure`
- `de.renew.draw.ui.ontology.PointConstrainer` - interface to constrain a Point
- `de.renew.draw.ui.ontology.Toolbar` - a container holding toolbuttons whose tools can manipulate the data of a Drawing
- `de.renew.ioontology.exporting.ExportFormat` - this interface must be implemented to define new ExportFormats
- `de.renew.ioontology.exporting.ExportFormatMulti` - Container for ExportFormats. Is an ExportFormat itself. Can be used to arrange ExportFormats in groups.
- `de.renew.ioontology.importing.ImportFormat` - this interface must be implemented to define new ImportFormats
- `de.renew.ioontology.importing.ImportFormatMulti` - Container for ImportFormats. Is an ImportFormat itself. Can be used to arrange ImportFormats in groups.
- `de.renew.ioontology.exporting.ExportFormatHolder` - this interface can be implemented if you want to implement your own export format holders
- `de.renew.ioontology.importing.ImportFormatHolder` - this interface can be implemented if you want to implement your own import format holders
- `de.renew.draw.ui.ontology.StatusDisplayer` - this interface must be implemented to display a message as a status.
- `CH.ifa.draw.standard.SelectionChangeListener`
- `CH.ifa.draw.standard.StringMatcher` - StringMatcher provides the interface for classes that are able to match Strings with the given search String and can also replace - in case of a match - the matching part with the
   replacement string
- `CH.ifa.draw.standard.TextHolder` - the interface of a figure that has some editable text contents
- `CH.ifa.draw.util.Animatable` - Animatable defines a simple animation interface
- `CH.ifa.draw.util.AutosaveSaver`
- `CH.ifa.draw.util.PaletteListener` - interface for handling palette events
- `de.renew.draw.storables.ontology.DrawingListener` - interface to listen to drawing movements
- `de.renew.draw.storables.ontology.Storable` - interface that is used by StorableInput and StorableOutput to flatten and resurrect objects
- `de.renew.draw.ui.ontology.Tool` - a tool defines a mode of the drawing view