/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.jfiglet.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.gnu.jfiglet.core.FIGFontInfo;
import org.gnu.jfiglet.core.FIGure;

public final class FIGUtils {
    private static String lineSeparator = System.getProperty("line.separator");

    private FIGUtils() {
    }

    public static String getFIGFontInfoDescription(FIGFontInfo theInfo) {
        boolean isSmushingModeUniversal;
        String[] printDirectionsDescriptions = new String[]{"LEFT TO RIGHT", "RIGHT TO LEFT"};
        String[] layoutModesDescriptions = new String[]{"FULL SIZE", "FITTING", "SMUSHING", "FULL SIZE", "FITTING", "SMUSHING"};
        String info = "";
        Iterator commentsIt = theInfo.getCommentLines();
        while (commentsIt.hasNext()) {
            info = info + commentsIt.next() + lineSeparator;
        }
        info = info + "Font name = " + theInfo.getName() + lineSeparator;
        info = info + "Font height = " + theInfo.getHeight() + lineSeparator;
        info = info + "Font baseline = " + theInfo.getBaseline() + lineSeparator;
        info = info + "Font max length = " + theInfo.getMaxLength() + lineSeparator;
        info = info + "Font print direction = " + printDirectionsDescriptions[theInfo.getPrintDirection()] + lineSeparator;
        info = info + "Font hardblank = " + theInfo.getHardblank() + lineSeparator;
        info = info + "Font layout : " + lineSeparator;
        info = info + "\t Horizontal mode = " + layoutModesDescriptions[theInfo.getLayout().getHorizontalMode()] + lineSeparator;
        if (theInfo.getLayout().getHorizontalMode() == 2) {
            info = info + "\t\t Smushing rules = ";
            isSmushingModeUniversal = true;
            if (theInfo.getLayout().hasHorizontalSmushingRule(16)) {
                info = info + "RULE_BIG_X ";
                isSmushingModeUniversal = false;
            }
            if (theInfo.getLayout().hasHorizontalSmushingRule(1)) {
                info = info + "EQUALS_CHARACTER ";
                isSmushingModeUniversal = false;
            }
            if (theInfo.getLayout().hasHorizontalSmushingRule(32)) {
                info = info + "HARDBLANK ";
                isSmushingModeUniversal = false;
            }
            if (theInfo.getLayout().hasHorizontalSmushingRule(4)) {
                info = info + "HIERARCHY ";
                isSmushingModeUniversal = false;
            }
            if (theInfo.getLayout().hasHorizontalSmushingRule(8)) {
                info = info + "OPPOSITE_PAIR ";
                isSmushingModeUniversal = false;
            }
            if (theInfo.getLayout().hasHorizontalSmushingRule(2)) {
                info = info + "UNDERSCORE ";
                isSmushingModeUniversal = false;
            }
            if (isSmushingModeUniversal) {
                info = info + "UNIVERSAL";
            }
            info = info + lineSeparator;
        }
        info = info + "\t Vertical mode = " + layoutModesDescriptions[theInfo.getLayout().getVerticalMode()] + lineSeparator;
        if (theInfo.getLayout().getVerticalMode() == 5) {
            info = info + "\t\t Smushing rules = ";
            isSmushingModeUniversal = true;
            if (theInfo.getLayout().hasVerticalSmushingRule(256)) {
                info = info + "EQUALS_CHARACTER ";
                isSmushingModeUniversal = false;
            }
            if (theInfo.getLayout().hasVerticalSmushingRule(1024)) {
                info = info + "HIERARCHY ";
                isSmushingModeUniversal = false;
            }
            if (theInfo.getLayout().hasVerticalSmushingRule(2048)) {
                info = info + "HORIZONTAL_LINE ";
                isSmushingModeUniversal = false;
            }
            if (theInfo.getLayout().hasVerticalSmushingRule(512)) {
                info = info + "UNDERSCORE ";
                isSmushingModeUniversal = false;
            }
            if (theInfo.getLayout().hasVerticalSmushingRule(4096)) {
                info = info + "VERTICAL_LINE ";
                isSmushingModeUniversal = false;
            }
            if (isSmushingModeUniversal) {
                info = info + "UNIVERSAL";
            }
            info = info + lineSeparator;
        }
        return info;
    }

    public static void renderFIGureToOutputStream(FIGure theFIGure, OutputStream theOutputStream, String theLineSeparator) throws IOException {
        if (theFIGure == null || theOutputStream == null) {
            throw new IllegalArgumentException("the FIGure and the OuptutStream musn't be null");
        }
        String lineSeparatorToUse = theLineSeparator == null ? lineSeparator : theLineSeparator;
        OutputStreamWriter writer = new OutputStreamWriter(theOutputStream);
        String[] linesToDisplay = theFIGure.getSubcharactersLines();
        for (int lineIndex = 0; lineIndex < linesToDisplay.length; ++lineIndex) {
            writer.write(linesToDisplay[lineIndex]);
            writer.write(lineSeparatorToUse);
            writer.flush();
        }
    }
}

