/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.flap.layer.FlapOverrideDropLayer;
import bibliothek.gui.dock.station.flap.layer.FlapSideDropLayer;
import bibliothek.gui.dock.station.flap.layer.WindowDropLayer;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.title.DockTitleRequest;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFlapDockStation
extends FlapDockStation
implements CommonDockStation<FlapDockStation, CFlapDockStation> {
    private CommonStationDelegate<CFlapDockStation> delegate;
    private Component expansion;
    private CHoldActionHandler actionHandler = new CHoldActionHandler();

    public CFlapDockStation(Component expansion, CommonStationDelegate<CFlapDockStation> delegate) {
        this.expansion = expansion;
        this.delegate = delegate;
        this.addDockStationListener(new HoldActionHandler());
    }

    @Override
    public String getFactoryID() {
        return "CommonDockStationFactory";
    }

    @Override
    public String getConverterID() {
        return super.getFactoryID();
    }

    public CDockable getDockable() {
        return this.delegate.getDockable();
    }

    public DockActionSource[] getSources() {
        return this.delegate.getSources();
    }

    @Override
    public CStation<CFlapDockStation> getStation() {
        return this.delegate.getStation();
    }

    @Override
    public FlapDockStation getDockStation() {
        return this;
    }

    @Override
    public CFlapDockStation asDockStation() {
        return this;
    }

    @Override
    public CommonDockable asDockable() {
        return null;
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        DockStationDropLayer[] layers = this.getDockableCount() == 0 ? new DockStationDropLayer[4] : new DockStationDropLayer[]{new DefaultDropLayer(this){

            public Component getComponent() {
                return CFlapDockStation.this.getComponent();
            }
        }, new FlapOverrideDropLayer(this){

            public Component getComponent() {
                return CFlapDockStation.this.getComponent();
            }
        }, new WindowDropLayer(this)};
        if (this.getDockableCount() == 0) {
            layers[3] = new FlapSideDropLayer(this){

                public Component getComponent() {
                    return CFlapDockStation.this.getComponent();
                }
            };
        }
        return layers;
    }

    @Override
    protected FlapDockStation.DockableHandle createHandle(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            FlapDockStation.DockableHandle handle = new FlapDockStation.DockableHandle(this, dockable, true);
            this.update(handle, ((CommonDockable)dockable).getDockable());
            return handle;
        }
        return super.createHandle(dockable);
    }

    private void update(FlapDockStation.DockableHandle handle, CDockable dockable) {
        CAction action = dockable.getAction("cdockable.hold");
        if (action == null) {
            handle.resetHoldAction();
        } else {
            handle.getActions().setHoldAction(action.intern());
        }
    }

    @Override
    public Rectangle getExpansionBounds() {
        if (this.expansion == null) {
            return super.getExpansionBounds();
        }
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(this.getComponent(), point, this.expansion);
        return new Rectangle(-point.x, -point.y, this.expansion.getWidth(), this.expansion.getHeight());
    }

    @Override
    public void requestDockTitle(DockTitleRequest request) {
        if (this.delegate.isTitleDisplayed(request.getVersion())) {
            super.requestDockTitle(request);
        } else {
            request.answer(null);
        }
    }

    private class CHoldActionHandler
    extends CDockableAdapter {
        private CHoldActionHandler() {
        }

        public void actionChanged(CDockable dockable, String key, CAction oldAction, CAction newAction) {
            FlapDockStation.DockableHandle handle;
            if (key.equals("cdockable.hold") && (handle = CFlapDockStation.this.getHandle(dockable.intern())) != null) {
                CFlapDockStation.this.update(handle, dockable);
            }
        }
    }

    private class HoldActionHandler
    extends DockStationAdapter {
        private HoldActionHandler() {
        }

        public void dockableAdded(DockStation station, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(CFlapDockStation.this.actionHandler);
            }
        }

        public void dockableRemoved(DockStation station, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(CFlapDockStation.this.actionHandler);
            }
        }
    }
}

