/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.searcher.EarlyExecutable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.inscription.arc.FlexibleArc;
import de.renew.net.inscription.arc.InputArcExecutable;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;
import java.util.Vector;

class FlexibleInArcExecutable
implements EarlyExecutable {
    private final SimulatablePlaceInstance _placeInstance;
    private final Vector<Object> _tokens;
    private final FlexibleArc _arc;
    private final Vector<Double> _removedTimes;
    private int _numRemoved;

    FlexibleInArcExecutable(SimulatablePlaceInstance placeInstance, Vector<Object> tokens, FlexibleArc arc) {
        this._placeInstance = placeInstance;
        this._tokens = tokens;
        this._arc = arc;
        this._numRemoved = 0;
        this._removedTimes = new Vector();
    }

    public long lockPriority() {
        return this._placeInstance.getLockOrder();
    }

    @Override
    public int phase() {
        return -3;
    }

    public void lock() {
        this._placeInstance._lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        try {
            for (int i = 0; i < this._tokens.size(); ++i) {
                Object token = this._tokens.elementAt(i);
                double removedTime = this._placeInstance.removeToken(token, 0.0);
                this._removedTimes.addElement(removedTime);
                ++this._numRemoved;
            }
        }
        catch (Exception e) {
            this.rollback();
            throw new Impossible();
        }
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        boolean isFastBoth = this._arc.getArcType() == FlexibleArc.FAST_BOTH;
        for (int i = 0; i < this._numRemoved; ++i) {
            Object token = this._tokens.elementAt(i);
            if (this._arc.isTrace()) {
                InputArcExecutable.traceInArc(stepIdentifier, isFastBoth, token, this._placeInstance);
            }
            if (!isFastBoth) continue;
            this._placeInstance.insertToken(token, SearchQueue.getTime());
        }
    }

    @Override
    public void rollback() {
        for (int i = 0; i < this._numRemoved; ++i) {
            this._placeInstance.internallyInsertToken(this._tokens.get(i), this._removedTimes.get(i), false);
        }
    }

    public void unlock() {
        this._placeInstance._lock.unlock();
    }
}

