/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.inscription.AbstractOccurrence;
import de.renew.net.inscription.arc.FlexibleArc;
import de.renew.net.inscription.arc.FlexibleArcBinder;
import de.renew.net.inscription.arc.FlexibleInArcExecutable;
import de.renew.net.inscription.arc.FlexibleOutArcExecutable;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

class FlexibleArcOccurrence
extends AbstractOccurrence {
    private final SimulatablePlaceInstance _placeInstance;
    private final VariableMapper _mapper;
    private Variable _tokenVar;
    private final FlexibleArc _arc;
    private Vector<Object> _inTokens;

    public FlexibleArcOccurrence(FlexibleArc arc, VariableMapper mapper, NetInstance netInstance) {
        super(netInstance.getInstance(arc.getTransition()));
        this._arc = arc;
        this._mapper = mapper;
        this._placeInstance = (SimulatablePlaceInstance)netInstance.getInstance(arc.getPlace());
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        IStateRecorder stateRecorder = searcher.getStateRecorder();
        ICalculationChecker calculationChecker = searcher.getCalculationChecker();
        this._tokenVar = new Variable(this._arc.getExpression().startEvaluation(this._mapper, stateRecorder, calculationChecker), stateRecorder);
        if (this._arc.getArcType() == FlexibleArc.OUT) {
            calculationChecker.addLateVariable(this._tokenVar, stateRecorder);
            return Collections.emptySet();
        }
        Vector<Binder> coll = new Vector<Binder>();
        coll.add(new FlexibleArcBinder(this));
        return coll;
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier copier) {
        Vector<Executable> coll = new Vector<Executable>();
        switch (this._arc.getArcType()) {
            case OUT: {
                Variable copiedTokenVar = (Variable)copier.getCopier().copy(this._tokenVar);
                coll.add(new FlexibleOutArcExecutable(this._placeInstance, copiedTokenVar, this._arc));
                return coll;
            }
            case IN: 
            case FAST_BOTH: {
                coll.add(new FlexibleInArcExecutable(this._placeInstance, this._inTokens, this._arc));
                return coll;
            }
        }
        throw new RuntimeException("Bad arc type.");
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier variableMapperCopier) {
        return null;
    }

    SimulatablePlaceInstance getPlaceInstance() {
        return this._placeInstance;
    }

    Variable getTokenVar() {
        return this._tokenVar;
    }

    FlexibleArc getArc() {
        return this._arc;
    }

    Vector<Object> getInTokens() {
        return this._inTokens;
    }

    void setInTokens(Vector<Object> inTokens) {
        this._inTokens = inTokens;
    }
}

