/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.net.TimeSetResult;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class TimeSet
implements Serializable {
    public static final TimeSet EMPTY = new TimeSet(null, 0.0, 0, null);
    public static final TimeSet ZERO = EMPTY.including(0.0);
    private final TimeSet _left;
    private final double _time;
    private final TimeSet _right;
    private final int _mult;
    private final int _height;
    private final int _size;
    private final int _uniqueSize;

    private TimeSet(TimeSet left, double time, int mult, TimeSet right) {
        if (mult == 0) {
            if (left != null || right != null || time != 0.0) {
                throw new RuntimeException("Bad empty time set parameters.");
            }
            this._left = null;
            this._right = null;
            this._mult = 0;
            this._time = 0.0;
            this._height = 0;
            this._size = 0;
            this._uniqueSize = 0;
        } else {
            int diff = left._height - right._height;
            if (diff >= 2) {
                if (left._left._height > left._right._height) {
                    this._left = left._left;
                    this._time = left._time;
                    this._mult = left._mult;
                    this._right = new TimeSet(left._right, time, mult, right);
                } else {
                    this._left = new TimeSet(left._left, left._time, left._mult, left._right._left);
                    this._time = left._right._time;
                    this._mult = left._right._mult;
                    this._right = new TimeSet(left._right._right, time, mult, right);
                }
            } else if (diff <= -2) {
                if (right._right._height > right._left._height) {
                    this._left = new TimeSet(left, time, mult, right._left);
                    this._time = right._time;
                    this._mult = right._mult;
                    this._right = right._right;
                } else {
                    this._left = new TimeSet(left, time, mult, right._left._left);
                    this._time = right._left._time;
                    this._mult = right._left._mult;
                    this._right = new TimeSet(right._left._right, right._time, right._mult, right._right);
                }
            } else {
                this._left = left;
                this._time = time;
                this._mult = mult;
                this._right = right;
            }
            this._height = Math.max(left._height, right._height) + 1;
            this._size = left._size + right._size + mult;
            this._uniqueSize = left._uniqueSize + right._uniqueSize + 1;
        }
    }

    public boolean isEmpty() {
        return this._mult == 0;
    }

    public static TimeSet make(double time, int mult) {
        return new TimeSet(EMPTY, time, mult, EMPTY);
    }

    public int getSize() {
        return this._size;
    }

    private TimeSet findNode(double searchTime) {
        TimeSet current = this;
        while (current._mult != 0) {
            if (current._time == searchTime) {
                return current;
            }
            if (current._time < searchTime) {
                current = current._right;
                continue;
            }
            current = current._left;
        }
        return EMPTY;
    }

    public int multiplicity(double searchTime) {
        return this.findNode((double)searchTime)._mult;
    }

    public TimeSet including(double newTime) {
        return this.including(newTime, 1);
    }

    public TimeSet including(double newTime, int n) {
        TimeSet newRight;
        TimeSet newLeft;
        if (this._mult == 0) {
            return TimeSet.make(newTime, n);
        }
        if (newTime == this._time) {
            return new TimeSet(this._left, this._time, this._mult + n, this._right);
        }
        if (newTime < this._time) {
            newLeft = this._left.including(newTime, n);
            newRight = this._right;
        } else {
            newLeft = this._left;
            newRight = this._right.including(newTime, n);
        }
        return new TimeSet(newLeft, this._time, this._mult, newRight);
    }

    public TimeSet excluding(double oldTime) {
        int newMult;
        double newTime;
        TimeSet newRight;
        TimeSet newLeft;
        if (this._mult == 0) {
            throw new NoSuchElementException();
        }
        if (oldTime == this._time) {
            if (this._mult > 1) {
                newLeft = this._left;
                newRight = this._right;
                newTime = this._time;
                newMult = this._mult - 1;
            } else {
                if (this._right._mult == 0) {
                    return this._left;
                }
                if (this._left._mult == 0) {
                    return this._right;
                }
                TimeSetResult reordered = this._right.extractLeftmost();
                newLeft = this._left;
                newRight = reordered._tree;
                newTime = reordered._time;
                newMult = reordered._mult;
            }
        } else {
            if (oldTime < this._time) {
                newLeft = this._left.excluding(oldTime);
                newRight = this._right;
            } else {
                newLeft = this._left;
                newRight = this._right.excluding(oldTime);
            }
            newTime = this._time;
            newMult = this._mult;
        }
        return new TimeSet(newLeft, newTime, newMult, newRight);
    }

    private TimeSetResult extractLeftmost() {
        if (this._mult == 0) {
            throw new RuntimeException("Illegal invocation of extractLeftmost().");
        }
        if (this._left._mult == 0) {
            return new TimeSetResult(this._right, this._time, this._mult);
        }
        TimeSetResult lifted = this._left.extractLeftmost();
        return new TimeSetResult(new TimeSet(lifted._tree, this._time, this._mult, this._right), lifted._time, lifted._mult);
    }

    public double earliestTime() {
        TimeSet tree = this;
        while (tree._left._mult != 0) {
            tree = tree._left;
        }
        return tree._time;
    }

    public double latestTime() {
        TimeSet tree = this;
        if (this._mult == 0) {
            throw new NoSuchElementException();
        }
        while (tree._right._mult != 0) {
            tree = tree._right;
        }
        return tree._time;
    }

    public double latestWithDelay(double delay, double deadline) {
        TimeSet current = this;
        TimeSet best = null;
        while (current._mult != 0) {
            if (current._time + delay <= deadline) {
                best = current;
                current = current._right;
                continue;
            }
            current = current._left;
        }
        if (best == null) {
            throw new NoSuchElementException();
        }
        return best._time;
    }

    public double[] asUniqueArray() {
        double[] result = new double[this._uniqueSize];
        this.fillIn(result, 0, true);
        return result;
    }

    public double[] asArray() {
        double[] result = new double[this._size];
        this.fillIn(result, 0, false);
        return result;
    }

    private void fillIn(double[] result, int start, boolean unique) {
        if (this._mult == 0) {
            return;
        }
        this._left.fillIn(result, start, unique);
        if (unique) {
            start += this._left._uniqueSize;
            result[start++] = this._time;
        } else {
            start += this._left._size;
            for (int i = 0; i < this._mult; ++i) {
                result[start++] = this._time;
            }
        }
        this._right.fillIn(result, start, unique);
    }

    public double computeEarliestTime(TimeSet that) {
        return this.computeEarliestTime(that.asArray());
    }

    public double computeEarliestTime(double[] delays) {
        if (delays.length > this._size) {
            return Double.POSITIVE_INFINITY;
        }
        return this.computeEarliestTime(delays, delays.length - 1);
    }

    private double computeEarliestTime(double[] delays, int offset) {
        double earliest = Double.NEGATIVE_INFINITY;
        if (this._mult > 0) {
            earliest = this._left.computeEarliestTime(delays, offset);
            if ((offset -= this._left._size) >= 0) {
                earliest = Math.max(earliest, this._time + delays[offset]);
                if ((offset -= this._mult) >= 0) {
                    earliest = Math.max(earliest, this._right.computeEarliestTime(delays, offset));
                }
            }
        }
        return earliest;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TimeSet(");
        this.toString(buffer);
        buffer.append(')');
        return buffer.toString();
    }

    private void toString(StringBuffer buffer) {
        if (this._mult == 0) {
            return;
        }
        this._left.toString(buffer);
        for (int i = 0; i < this._mult; ++i) {
            buffer.append(' ');
            buffer.append(this._time);
        }
        this._right.toString(buffer);
    }
}

