/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.database.TransactionSource;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.OverallEarliestTimeFinder;
import de.renew.engine.simulator.SimulatorEventQueue;
import de.renew.engine.simulator.StepIdentifierFactory;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.simulatorontology.simulation.Simulator;
import de.renew.simulatorontology.simulation.StepIdentifier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SequentialSimulator
implements Simulator,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(SequentialSimulator.class);
    private static long _runCounter = 0L;
    private final long _simulationRunId;
    private ExecuteFinder _finder;
    private final Searcher _searcher = new Searcher();
    private boolean _stepFired = false;
    private boolean _isAlive = false;
    private boolean _wantBreak = false;
    private SequentialSimulator _runThread = null;
    private final StepIdentifierFactory _stepIdentifierFactory;
    private final boolean _wantEventQueueDelay;

    public SequentialSimulator() {
        this(true);
    }

    public SequentialSimulator(boolean wantEventQueueDelay) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._wantEventQueueDelay = wantEventQueueDelay;
        this._simulationRunId = ((long)this.getClass().getName().hashCode() << 32) + _runCounter++;
        this._stepIdentifierFactory = new StepIdentifierFactory(this._simulationRunId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this.getClass().getSimpleName() + ": Starting run with id " + this._simulationRunId));
        }
        this.findNewBinding();
    }

    public boolean isActive() {
        return this._isAlive;
    }

    public synchronized void startRun() {
        if (this._runThread != null) {
            return;
        }
        this._runThread = this;
        SimulationThreadPool.getCurrent().execute(this);
        try {
            TransactionSource.simulationStateChanged(true, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void stopRun() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> {
            while (this._runThread != null) {
                this._wantBreak = true;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                TransactionSource.simulationStateChanged(true, false);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        });
    }

    public synchronized void terminateRun() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> {
            this.stopRun();
            try {
                TransactionSource.simulationStateChanged(false, false);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        });
    }

    private void fire() {
        this._stepFired = false;
        while (this._isAlive && !this._stepFired) {
            if (this._wantEventQueueDelay) {
                SimulatorEventQueue.awaitEmptyQueue();
            }
            this._stepFired = this._finder.execute(this.nextStepIdentifier(), false);
            this.findNewBinding();
        }
    }

    private void findNewBinding() {
        this._finder = new ExecuteFinder();
        while (!this._finder.isCompleted() && !SearchQueue.isTotallyEmpty()) {
            Searchable searchable = SearchQueue.extract();
            OverallEarliestTimeFinder timeFinder = new OverallEarliestTimeFinder(this._finder);
            this._searcher.searchAndRecover(timeFinder, searchable, searchable);
            timeFinder.insertIntoSearchQueue(searchable);
        }
        this._isAlive = this._finder.isCompleted();
    }

    public synchronized int step() {
        Future<Integer> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
            if (this._runThread != null) {
                this.stopRun();
                if (this._isAlive && !this._stepFired) {
                    this.fire();
                }
            } else {
                this.fire();
            }
            if (this._stepFired) {
                return this._isAlive ? 1 : 2;
            }
            return 4;
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this._isAlive) {
            this.findNewBinding();
        }
        while (this._isAlive && !this._wantBreak) {
            Thread.yield();
            this.fire();
        }
        SequentialSimulator sequentialSimulator = this;
        synchronized (sequentialSimulator) {
            this._runThread = null;
            this._wantBreak = false;
            this.notifyAll();
        }
    }

    public synchronized void refresh() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> {
            if (this._runThread == null) {
                this.findNewBinding();
            }
        });
    }

    public boolean isSequential() {
        return true;
    }

    public StepIdentifier nextStepIdentifier() {
        return this._stepIdentifierFactory.nextStepIdentifier();
    }

    public StepIdentifier currentStepIdentifier() {
        return this._stepIdentifierFactory.currentStepIdentifier();
    }

    public long[] collectSimulationRunIds() {
        return new long[]{this._simulationRunId};
    }
}

