/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searchqueue;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searchqueue.RandomQueueFactory;
import de.renew.engine.searchqueue.SearchQueueData;
import de.renew.engine.searchqueue.SearchQueueFactory;
import de.renew.engine.searchqueue.SearchQueueListener;
import de.renew.engine.searchqueue.TimeListener;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SearchQueue {
    private static final Logger LOGGER = Logger.getLogger(SearchQueue.class);
    private static double _time = 0.0;
    private static SortedMap<Double, SearchQueueData> _queueByTime = new TreeMap<Double, SearchQueueData>();
    private static Hashtable<Searchable, SearchQueueData> _queueBySearchable = new Hashtable();
    private static SearchQueueFactory _factory = new RandomQueueFactory();
    private static final List<SearchQueueListener> LISTENERS = new ArrayList<SearchQueueListener>();
    private static final List<TimeListener> TIME_LISTENERS = new ArrayList<TimeListener>();

    private SearchQueue() {
    }

    public static synchronized void setQueueFactory(SearchQueueFactory factory) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        _factory = factory;
        _queueBySearchable = new Hashtable();
        for (Double key : _queueByTime.keySet()) {
            SearchQueueData oldQueue = (SearchQueueData)_queueByTime.get(key);
            SearchQueueData newQueue = _factory.makeQueue(oldQueue.getTime());
            Enumeration<Searchable> e = oldQueue.elements();
            while (e.hasMoreElements()) {
                Searchable searchable = e.nextElement();
                newQueue.include(searchable);
                _queueBySearchable.put(searchable, newQueue);
            }
            _queueByTime.put(key, newQueue);
        }
    }

    private static void setTime(double time) {
        _time = time;
        SearchQueue.notifyTimeListeners();
    }

    public static synchronized void reset(double startTime) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread but instead: " + String.valueOf(Thread.currentThread().getThreadGroup());
        _queueByTime = new TreeMap<Double, SearchQueueData>();
        _queueBySearchable = new Hashtable();
        SimulatorEventLogger.log("Setting time to " + startTime);
        SearchQueue.setTime(startTime);
    }

    public static synchronized double getTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return _time;
    }

    private static void advanceTime(double newTime) {
        if (newTime > _time) {
            LOGGER.info((Object)("Advancing time to " + newTime));
            SearchQueue.setTime(newTime);
        }
    }

    public static synchronized void advanceTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SearchQueueData queue = SearchQueue.getEarliestQueue();
        if (queue != null) {
            _queueByTime.remove(queue.getTime());
            SearchQueue.advanceTime(queue.getTime());
        }
    }

    private static SearchQueueData getEarliestQueue() {
        if (_queueByTime.isEmpty()) {
            return null;
        }
        Double firstKey = _queueByTime.firstKey();
        return (SearchQueueData)_queueByTime.get(firstKey);
    }

    public static synchronized boolean isCurrentlyEmpty() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return !_queueByTime.containsKey(_time);
    }

    public static synchronized boolean isTotallyEmpty() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return _queueByTime.isEmpty();
    }

    public static synchronized void insertListener(SearchQueueListener listener) {
        LISTENERS.add(listener);
    }

    public static synchronized void insertTimeListener(TimeListener listener) {
        TIME_LISTENERS.add(listener);
    }

    public static synchronized void removeTimeListener(TimeListener listener) {
        TIME_LISTENERS.remove(listener);
    }

    private static void notifyListeners() {
        LISTENERS.forEach(SearchQueueListener::searchQueueNonempty);
        LISTENERS.clear();
    }

    private static void notifyTimeListeners() {
        ArrayList<TimeListener> temp = new ArrayList<TimeListener>(TIME_LISTENERS);
        temp.forEach(TimeListener::timeAdvanced);
    }

    public static synchronized void includeNow(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SearchQueue.include(searchable, _time);
    }

    public static synchronized void include(Searchable searchable, double targetTime) {
        SearchQueueData queue;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (targetTime < _time) {
            targetTime = _time;
        }
        if (targetTime == _time) {
            searchable.triggers().clear();
        }
        if ((queue = _queueBySearchable.get(searchable)) != null && targetTime < queue.getTime()) {
            queue.exclude(searchable);
            _queueBySearchable.remove(searchable);
            if (queue.size() == 0) {
                _queueByTime.remove(queue.getTime());
            }
            queue = null;
        }
        if (queue == null) {
            Double key = targetTime;
            if (_queueByTime.containsKey(key)) {
                queue = (SearchQueueData)_queueByTime.get(key);
            } else {
                queue = _factory.makeQueue(targetTime);
                _queueByTime.put(key, queue);
            }
            queue.include(searchable);
            _queueBySearchable.put(searchable, queue);
        }
        SearchQueue.notifyListeners();
    }

    public static synchronized Searchable extract() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SearchQueueData queue = SearchQueue.getEarliestQueue();
        if (queue == null) {
            return null;
        }
        SearchQueue.advanceTime(queue.getTime());
        Searchable searchable = queue.extract();
        _queueBySearchable.remove(searchable);
        if (queue.size() == 0) {
            _queueByTime.remove(queue.getTime());
        }
        return searchable;
    }

    public static synchronized void saveQueue(ObjectOutput output) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (output instanceof RenewObjectOutputStream) {
            RenewObjectOutputStream out;
            rOut = out = (RenewObjectOutputStream)output;
            rOut.beginDomain(SearchQueue.class);
        }
        output.writeInt(_queueByTime.size());
        for (Map.Entry<Double, SearchQueueData> entry : _queueByTime.entrySet()) {
            output.writeDouble(entry.getKey());
            SearchQueueData data = entry.getValue();
            output.writeInt(data.size());
            Enumeration<Searchable> elements = data.elements();
            while (elements.hasMoreElements()) {
                output.writeObject(elements.nextElement());
            }
        }
        if (rOut != null) {
            rOut.writeDelayedObjects();
        }
        if (rOut != null) {
            rOut.endDomain(SearchQueue.class);
        }
    }

    public static synchronized void loadQueue(ObjectInput input) throws IOException, ClassNotFoundException {
        int i;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ArrayList<Object> allEntries = new ArrayList<Object>();
        ArrayList<Double> allTimes = new ArrayList<Double>();
        int count = input.readInt();
        try {
            for (i = 0; i < count; ++i) {
                Double time = input.readDouble();
                int size = input.readInt();
                for (int j = 0; j < size; ++j) {
                    allEntries.add(input.readObject());
                    allTimes.add(time);
                }
            }
        }
        catch (ClassCastException e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            throw new StreamCorruptedException("Object other than Searchable found when looking for SearchQueue elements: " + e.getMessage());
        }
        if (input instanceof RenewObjectInputStream) {
            RenewObjectInputStream in = (RenewObjectInputStream)input;
            in.readDelayedObjects();
        }
        for (i = 0; i < allEntries.size(); ++i) {
            SearchQueue.include((Searchable)allEntries.get(i), (Double)allTimes.get(i));
        }
    }
}

