/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graphs.traversal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.automatalib.commons.util.Holder;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.util.graphs.traversal.BFRecord;
import net.automatalib.util.graphs.traversal.BreadthFirstIterator;
import net.automatalib.util.graphs.traversal.DFRecord;
import net.automatalib.util.graphs.traversal.DFSTraversalVisitor;
import net.automatalib.util.graphs.traversal.DFSVisitor;
import net.automatalib.util.graphs.traversal.DepthFirstIterator;
import net.automatalib.util.graphs.traversal.GraphTraversalAction;
import net.automatalib.util.graphs.traversal.GraphTraversalVisitor;
import net.automatalib.util.traversal.TraversalOrder;

public final class GraphTraversal {
    private GraphTraversal() {
    }

    public static <N, E, D> boolean traverse(TraversalOrder order, IndefiniteGraph<N, E> graph, int limit, N initialNode, GraphTraversalVisitor<N, E, D> vis) {
        return GraphTraversal.traverse(order, graph, limit, Collections.singleton(initialNode), vis);
    }

    public static <N, E, D> boolean traverse(TraversalOrder order, IndefiniteGraph<N, E> graph, int limit, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> vis) {
        switch (order) {
            case BREADTH_FIRST: {
                return GraphTraversal.breadthFirst(graph, limit, initialNodes, vis);
            }
            case DEPTH_FIRST: {
                return GraphTraversal.depthFirst(graph, limit, initialNodes, vis);
            }
        }
        throw new IllegalArgumentException("Unknown traversal order " + (Object)((Object)order));
    }

    public static <N, E, D> boolean traverse(TraversalOrder order, IndefiniteGraph<N, E> graph, N initialNode, GraphTraversalVisitor<N, E, D> vis) {
        return GraphTraversal.traverse(order, graph, -1, Collections.singleton(initialNode), vis);
    }

    public static <N, E, D> boolean traverse(TraversalOrder order, IndefiniteGraph<N, E> graph, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> vis) {
        return GraphTraversal.traverse(order, graph, -1, initialNodes, vis);
    }

    public static <N, E, D> boolean depthFirst(IndefiniteGraph<N, E> graph, int limit, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> vis) {
        boolean complete = true;
        int nodeCount = 0;
        ArrayDeque dfsStack = new ArrayDeque();
        Holder dataHolder = new Holder();
        block11: for (N init : initialNodes) {
            dataHolder.value = null;
            GraphTraversalAction act = vis.processInitial(init, dataHolder);
            switch (act) {
                case IGNORE: 
                case ABORT_NODE: {
                    continue block11;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (nodeCount != limit) {
                        dfsStack.push(new DFRecord(init, dataHolder.value));
                        ++nodeCount;
                        continue block11;
                    }
                    complete = false;
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unknown action " + (Object)((Object)act));
        }
        block12: while (!dfsStack.isEmpty()) {
            DFRecord current = (DFRecord)dfsStack.peek();
            Object currNode = current.node;
            Object currData = current.data;
            if (current.start(graph) && !vis.startExploration(currNode, currData)) {
                dfsStack.pop();
                continue;
            }
            DFRecord.LastEdge lastEdge = current.getLastEdge();
            if (lastEdge != null) {
                vis.backtrackEdge(currNode, currData, lastEdge.edge, lastEdge.node, lastEdge.data);
            }
            if (!current.hasNextEdge()) {
                dfsStack.pop();
                vis.finishExploration(currNode, currData);
                continue;
            }
            Object edge = current.nextEdge();
            N tgt = graph.getTarget(edge);
            GraphTraversalAction act = vis.processEdge(currNode, currData, edge, tgt, dataHolder);
            switch (act) {
                case IGNORE: {
                    continue block12;
                }
                case ABORT_NODE: {
                    dfsStack.pop();
                    continue block12;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (nodeCount != limit) {
                        Object data = dataHolder.value;
                        current.setLastEdge(edge, tgt, data);
                        dfsStack.push(new DFRecord(tgt, data));
                        ++nodeCount;
                        continue block12;
                    }
                    complete = false;
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unknown action " + (Object)((Object)act));
        }
        return complete;
    }

    public static <N, E, D> boolean depthFirst(IndefiniteGraph<N, E> graph, N initNode, GraphTraversalVisitor<N, E, D> vis) {
        return GraphTraversal.depthFirst(graph, -1, initNode, vis);
    }

    public static <N, E, D> boolean depthFirst(IndefiniteGraph<N, E> graph, int limit, N initNode, GraphTraversalVisitor<N, E, D> vis) {
        return GraphTraversal.depthFirst(graph, Collections.singleton(initNode), vis);
    }

    public static <N, E, D> boolean depthFirst(IndefiniteGraph<N, E> graph, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> vis) {
        return GraphTraversal.depthFirst(graph, -1, initialNodes, vis);
    }

    public static <N, E, D> boolean breadthFirst(IndefiniteGraph<N, E> graph, int limit, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> vis) {
        ArrayDeque bfsQueue = new ArrayDeque();
        boolean complete = true;
        int nodeCount = 0;
        Holder dataHolder = new Holder();
        block11: for (N init : initialNodes) {
            dataHolder.value = null;
            GraphTraversalAction act = vis.processInitial(init, dataHolder);
            switch (act) {
                case IGNORE: 
                case ABORT_NODE: {
                    continue block11;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (nodeCount != limit) {
                        bfsQueue.add(new BFRecord(init, dataHolder.value));
                        ++nodeCount;
                        continue block11;
                    }
                    complete = false;
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unknown action " + (Object)((Object)act));
        }
        block12: while (!bfsQueue.isEmpty()) {
            BFRecord current = (BFRecord)bfsQueue.poll();
            Object currNode = current.node;
            Object currData = current.data;
            if (!vis.startExploration(currNode, currData)) continue;
            Collection<E> edges = graph.getOutgoingEdges(currNode);
            block13: for (E edge : edges) {
                N tgtNode = graph.getTarget(edge);
                dataHolder.value = null;
                GraphTraversalAction act = vis.processEdge(currNode, currData, edge, tgtNode, dataHolder);
                switch (act) {
                    case IGNORE: {
                        continue block13;
                    }
                    case ABORT_NODE: {
                        continue block12;
                    }
                    case ABORT_TRAVERSAL: {
                        return complete;
                    }
                    case EXPLORE: {
                        if (nodeCount != limit) {
                            bfsQueue.offer(new BFRecord(tgtNode, dataHolder.value));
                            ++nodeCount;
                            continue block13;
                        }
                        complete = false;
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("Unknown action " + (Object)((Object)act));
            }
            vis.finishExploration(currNode, currData);
        }
        return complete;
    }

    public static <N, E, D> boolean breadthFirst(IndefiniteGraph<N, E> graph, int limit, N initialNode, GraphTraversalVisitor<N, E, D> visitor) {
        return GraphTraversal.breadthFirst(graph, limit, Collections.singleton(initialNode), visitor);
    }

    public static <N, E, D> boolean breadthFirst(IndefiniteGraph<N, E> graph, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> visitor) {
        return GraphTraversal.breadthFirst(graph, -1, initialNodes, visitor);
    }

    public static <N, E, D> boolean breadthFirst(IndefiniteGraph<N, E> graph, N initialNode, GraphTraversalVisitor<N, E, D> visitor) {
        return GraphTraversal.breadthFirst(graph, -1, Collections.singleton(initialNode), visitor);
    }

    public static <N, E, D> boolean dfs(IndefiniteGraph<N, E> graph, N initialNode, DFSVisitor<? super N, ? super E, D> visitor) {
        return GraphTraversal.dfs(graph, -1, Collections.singleton(initialNode), visitor);
    }

    public static <N, E, D> boolean dfs(IndefiniteGraph<N, E> graph, int limit, Collection<? extends N> initialNodes, DFSVisitor<? super N, ? super E, D> visitor) {
        DFSTraversalVisitor<? super N, ? super E, D> traversalVisitor = new DFSTraversalVisitor<N, E, D>(graph, visitor);
        return GraphTraversal.depthFirst(graph, limit, initialNodes, traversalVisitor);
    }

    public static <N, E, D> boolean dfs(IndefiniteGraph<N, E> graph, Collection<? extends N> initialNodes, DFSVisitor<? super N, ? super E, D> visitor) {
        return GraphTraversal.dfs(graph, -1, initialNodes, visitor);
    }

    public static <N, E> Iterable<N> breadthFirstOrder(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        return () -> GraphTraversal.bfIterator(graph, start);
    }

    public static <N, E> Iterator<N> bfIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        return new BreadthFirstIterator<N, E>(graph, start);
    }

    public static <N, E> Iterable<N> depthFirstOrder(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        return () -> GraphTraversal.dfIterator(graph, start);
    }

    public static <N, E> Iterator<N> dfIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        return new DepthFirstIterator<N, E>(graph, start);
    }
}

